/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.reload;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_6008;
import net.minecraft.class_6011;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class WeightedDynamicRegistry<V extends CodecProvider<? super V> & ILuckyWeighted>
extends DynamicRegistry<V> {
    protected List<class_6008.class_6010<V>> zeroLuckList = Collections.emptyList();
    protected int zeroLuckTotalWeight = 0;

    public WeightedDynamicRegistry(Logger logger, String path, boolean synced, boolean subtypes) {
        super(logger, path, synced, subtypes);
    }

    @Override
    protected void beginReload() {
        super.beginReload();
        this.zeroLuckList = Collections.emptyList();
        this.zeroLuckTotalWeight = 0;
    }

    @Override
    protected void validateItem(class_2960 key, V item) {
        super.validateItem(key, item);
        Preconditions.checkArgument((((ILuckyWeighted)item).getQuality() >= 0.0f ? 1 : 0) != 0, (Object)"Item may not have negative quality!");
        Preconditions.checkArgument((((ILuckyWeighted)item).getWeight() >= 0 ? 1 : 0) != 0, (Object)"Item may not have negative weight!");
    }

    @Override
    protected void onReload() {
        super.onReload();
        this.zeroLuckList = this.registry.values().stream().map(item -> class_6008.method_34980((Object)item, (int)((ILuckyWeighted)((Object)item)).getWeight())).toList();
        this.zeroLuckTotalWeight = class_6011.method_34984(this.zeroLuckList);
    }

    @Nullable
    public V getRandomItem(class_5819 rand) {
        return this.getRandomItem(rand, 0.0f);
    }

    @Nullable
    public V getRandomItem(class_5819 rand, float luck) {
        if (luck == 0.0f) {
            return (V)((CodecProvider)class_6011.method_34987((class_5819)rand, this.zeroLuckList, (int)this.zeroLuckTotalWeight).map(class_6008.class_6010::method_34983).orElse(null));
        }
        return this.getRandomItem(rand, luck, new Predicate[]{Predicates.alwaysTrue()});
    }

    @SafeVarargs
    @Nullable
    public final V getRandomItem(class_5819 rand, float luck, Predicate<V> ... filters) {
        ArrayList list = new ArrayList(this.zeroLuckList.size());
        Stream stream = this.registry.values().stream();
        for (Predicate<V> filter : filters) {
            stream = stream.filter(filter);
        }
        stream.map(l -> ((ILuckyWeighted)((Object)l)).wrap(luck)).forEach(list::add);
        return (V)((CodecProvider)class_6011.method_34986((class_5819)rand, list).map(class_6008.class_6010::method_34983).orElse(null));
    }

    public static interface ILuckyWeighted {
        public float getQuality();

        public int getWeight();

        default public <T extends ILuckyWeighted> class_6008.class_6010<T> wrap(float luck) {
            return ILuckyWeighted.wrap(this, luck);
        }

        public static <T extends ILuckyWeighted> class_6008.class_6010<T> wrap(T item, float luck) {
            return class_6008.method_34980(item, (int)Math.max(0, item.getWeight() + (int)(luck * item.getQuality())));
        }
    }

    public static interface IDimensional {
        @Nullable
        public Set<class_2960> getDimensions();

        public static <T extends IDimensional> Predicate<T> matches(class_2960 dimId) {
            return obj -> {
                Set<class_2960> dims = obj.getDimensions();
                return dims == null || dims.isEmpty() || dims.contains(dimId);
            };
        }

        public static <T extends IDimensional> Predicate<T> matches(class_1937 level) {
            return IDimensional.matches(level.method_27983().method_29177());
        }
    }
}

