/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.util;

import dev.shadowsoffire.placebo.Placebo;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.function.BooleanSupplier;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import org.apache.commons.lang3.tuple.Pair;

public class PlaceboTaskQueue {
    private static final Queue<Pair<String, BooleanSupplier>> TASKS = new ArrayDeque<Pair<String, BooleanSupplier>>();

    public static void init() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            Iterator it = TASKS.iterator();
            Pair current = null;
            while (it.hasNext()) {
                current = (Pair)it.next();
                try {
                    if (!((BooleanSupplier)current.getRight()).getAsBoolean()) continue;
                    it.remove();
                }
                catch (Exception ex) {
                    Placebo.LOGGER.error("An exception occurred while running a ticking task with ID {}.  It will be terminated.", current.getLeft());
                    it.remove();
                    ex.printStackTrace();
                }
            }
        });
        ServerWorldEvents.UNLOAD.register((server, world) -> TASKS.clear());
        ServerWorldEvents.LOAD.register((server, world) -> TASKS.clear());
    }

    public static void submitTask(String id, BooleanSupplier task) {
        TASKS.add((Pair<String, BooleanSupplier>)Pair.of((Object)id, (Object)task));
    }
}

