/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.client.gui;

import appeng.api.config.Settings;
import appeng.api.config.ShowPatternProviders;
import appeng.api.config.TerminalStyle;
import appeng.api.crafting.IPatternDetails;
import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.me.patternaccess.PatternContainerRecord;
import appeng.client.gui.me.patternaccess.PatternSlot;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.render.SimpleRenderContext;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.core.localization.GuiText;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.helpers.InventoryAction;
import appeng.util.inv.AppEngInternalInventory;
import com.github.glodblock.extendedae.client.button.HighlightButton;
import com.github.glodblock.extendedae.container.ContainerExPatternTerminal;
import com.google.common.collect.HashMultimap;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_768;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiExPatternTerminal<T extends ContainerExPatternTerminal>
extends AEBaseScreen<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GuiExPatternTerminal.class);
    private static final int GUI_WIDTH = 209;
    private static final int MAGIC_NUMBER = 50;
    private static final int GUI_TOP_AND_BOTTOM_PADDING = 54;
    private static final int GUI_PADDING_X = 22;
    private static final int GUI_PADDING_Y = 6;
    private static final int GUI_HEADER_HEIGHT = 51;
    private static final int GUI_FOOTER_HEIGHT = 97;
    private static final int COLUMNS = 9;
    private static final int PATTERN_PROVIDER_NAME_MARGIN_X = 2;
    private static final int TEXT_MAX_WIDTH = 155;
    private static final int ROW_HEIGHT = 18;
    private static final int SLOT_SIZE = 18;
    private static final class_768 HEADER_BBOX = new class_768(0, 0, 209, 51);
    private static final class_768 ROW_TEXT_TOP_BBOX = new class_768(0, 51, 209, 18);
    private static final class_768 ROW_TEXT_MIDDLE_BBOX = new class_768(0, 87, 209, 18);
    private static final class_768 ROW_TEXT_BOTTOM_BBOX = new class_768(0, 123, 209, 18);
    private static final class_768 ROW_INVENTORY_TOP_BBOX = new class_768(0, 69, 209, 18);
    private static final class_768 ROW_INVENTORY_MIDDLE_BBOX = new class_768(0, 105, 209, 18);
    private static final class_768 ROW_INVENTORY_BOTTOM_BBOX = new class_768(0, 141, 209, 18);
    private static final class_768 FOOTER_BBOX = new class_768(0, 159, 209, 97);
    private static final Comparator<PatternContainerGroup> GROUP_COMPARATOR = Comparator.comparing(group -> group.name().getString().toLowerCase(Locale.ROOT));
    private final HashMap<Long, PatternContainerRecord> byId = new HashMap();
    private final HashMap<Integer, HighlightButton> highlightBtns = new HashMap();
    private final HashMap<Long, PatternProviderInfo> infoMap = new HashMap();
    private final HashMultimap<PatternContainerGroup, PatternContainerRecord> byGroup = HashMultimap.create();
    private final ArrayList<PatternContainerGroup> groups = new ArrayList();
    private final ArrayList<Row> rows = new ArrayList();
    private final Map<String, Set<Object>> cachedSearches = new WeakHashMap<String, Set<Object>>();
    private final Set<class_1799> matchedStack = new ObjectOpenCustomHashSet((Hash.Strategy)new Hash.Strategy<class_1799>(){

        public int hashCode(class_1799 o) {
            return o.method_7909().hashCode() ^ (o.method_7985() ? o.method_7969().hashCode() : -1);
        }

        public boolean equals(class_1799 a, class_1799 b) {
            return a == b || a != null && b != null && class_1799.method_31577((class_1799)a, (class_1799)b);
        }
    });
    private final Set<PatternContainerRecord> matchedProvider = new HashSet<PatternContainerRecord>();
    private final Scrollbar scrollbar = this.widgets.addScrollBar("scrollbar");
    private final AETextField searchOutField;
    private final AETextField searchInField;
    private int visibleRows = 0;
    private final ServerSettingToggleButton<ShowPatternProviders> showPatternProviders;

    public GuiExPatternTerminal(T menu, class_1661 playerInventory, class_2561 title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        this.field_2792 = 209;
        TerminalStyle terminalStyle = AEConfig.instance().getTerminalStyle();
        this.addToLeftToolbar((class_4185)new SettingToggleButton(Settings.TERMINAL_STYLE, (Enum)terminalStyle, this::toggleTerminalStyle));
        this.showPatternProviders = new ServerSettingToggleButton(Settings.TERMINAL_SHOW_PATTERN_PROVIDERS, (Enum)ShowPatternProviders.VISIBLE);
        this.addToLeftToolbar((class_4185)this.showPatternProviders);
        this.searchOutField = this.widgets.addTextField("search_out");
        this.searchOutField.method_1863(str -> this.refreshList());
        this.searchOutField.setPlaceholder((class_2561)GuiText.SearchPlaceholder.text());
        this.searchOutField.setTooltipMessage(Collections.singletonList(class_2561.method_43471((String)"gui.extendedae.ex_pattern_access_terminal.tooltip.01")));
        this.searchInField = this.widgets.addTextField("search_in");
        this.searchInField.method_1863(str -> this.refreshList());
        this.searchInField.setPlaceholder((class_2561)GuiText.SearchPlaceholder.text());
        this.searchInField.setTooltipMessage(Collections.singletonList(class_2561.method_43471((String)"gui.extendedae.ex_pattern_access_terminal.tooltip.02")));
    }

    public void method_25426() {
        this.visibleRows = this.config.getTerminalStyle().getRows((this.field_22790 - 51 - 97 - 54 + 50) / 18);
        if (this.visibleRows < 2) {
            this.visibleRows = 2;
        }
        this.field_2779 = 148 + this.visibleRows * 18;
        super.method_25426();
        this.method_48265((class_364)this.searchOutField);
        this.highlightBtns.forEach((k, v) -> {
            v.setVisibility(false);
            this.method_37063((class_364)v);
        });
        this.resetScrollbar();
    }

    public void drawFG(class_332 guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        ((ContainerExPatternTerminal)this.field_2797).field_7761.removeIf(slot -> slot instanceof PatternSlot);
        this.highlightBtns.forEach((key, value) -> value.setVisibility(false));
        int textColor = this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR).toARGB();
        int scrollLevel = this.scrollbar.getCurrentScroll();
        for (int i = 0; i < this.visibleRows; ++i) {
            int rows;
            if (scrollLevel + i >= this.rows.size()) continue;
            Row row = this.rows.get(scrollLevel + i);
            if (this.highlightBtns.containsKey(scrollLevel + i)) {
                HighlightButton btn = this.highlightBtns.get(scrollLevel + i);
                btn.method_48229(this.field_2776 + 22 - 18, this.field_2800 + (i + 1) * 18 + 34);
                btn.setVisibility(true);
            }
            if (row instanceof SlotsRow) {
                SlotsRow slotsRow = (SlotsRow)row;
                PatternContainerRecord container = slotsRow.container;
                for (int col = 0; col < slotsRow.slots; ++col) {
                    PatternSlot slot2 = new PatternSlot(container, slotsRow.offset + col, col * 18 + 22, (i + 1) * 18 + 34);
                    ((ContainerExPatternTerminal)this.field_2797).field_7761.add((Object)slot2);
                    if (this.searchOutField.method_1882().isEmpty() && this.searchInField.method_1882().isEmpty()) continue;
                    if (this.matchedStack.contains(slot2.method_7677())) {
                        this.fillRect(guiGraphics, new class_768(slot2.field_7873, slot2.field_7872, 16, 16), -1979646208);
                        continue;
                    }
                    if (this.matchedProvider.contains(container)) continue;
                    this.fillRect(guiGraphics, new class_768(slot2.field_7873, slot2.field_7872, 16, 16), 0x6A000000);
                }
                continue;
            }
            if (!(row instanceof GroupHeaderRow)) continue;
            GroupHeaderRow headerRow = (GroupHeaderRow)row;
            PatternContainerGroup group = headerRow.group;
            if (group.icon() != null) {
                SimpleRenderContext renderContext = new SimpleRenderContext(LytRect.empty(), guiGraphics);
                renderContext.renderItem(group.icon().toStack(), 24, 57 + i * 18, 8.0f, 8.0f);
            }
            Object displayName = (rows = this.byGroup.get((Object)group).size()) > 1 ? class_2561.method_43473().method_10852(group.name()).method_10852((class_2561)class_2561.method_43470((String)(" (" + rows + ")"))) : group.name();
            class_5481 text = class_2477.method_10517().method_30934(this.field_22793.method_1714((class_5348)displayName, 145));
            guiGraphics.method_51430(this.field_22793, text, 34, 57 + i * 18, textColor, false);
        }
    }

    protected void method_2380(@NotNull class_332 guiGraphics, int x, int y) {
        Row row;
        int hoveredLineIndex;
        if (this.field_2787 == null && (hoveredLineIndex = this.getHoveredLineIndex(x, y)) != -1 && (row = this.rows.get(hoveredLineIndex)) instanceof GroupHeaderRow) {
            GroupHeaderRow headerRow = (GroupHeaderRow)row;
            if (!headerRow.group.tooltip().isEmpty()) {
                guiGraphics.method_51437(this.field_22793, headerRow.group.tooltip(), Optional.empty(), x, y);
                return;
            }
        }
        super.method_2380(guiGraphics, x, y);
    }

    private int getHoveredLineIndex(int x, int y) {
        x = x - this.field_2776 - 22;
        y = y - this.field_2800 - 18;
        if (x < 0 || y < 0) {
            return -1;
        }
        if (x >= 162 || y >= this.visibleRows * 18) {
            return -1;
        }
        int rowIndex = this.scrollbar.getCurrentScroll() + y / 18;
        if (rowIndex < 0 || rowIndex >= this.rows.size()) {
            return -1;
        }
        return rowIndex;
    }

    public boolean method_25402(double xCoord, double yCoord, int btn) {
        if (btn == 1 && this.searchOutField.method_25405(xCoord, yCoord)) {
            this.searchOutField.method_1852("");
        }
        if (btn == 1 && this.searchInField.method_25405(xCoord, yCoord)) {
            this.searchInField.method_1852("");
        }
        return super.method_25402(xCoord, yCoord, btn);
    }

    protected void method_2383(class_1735 slot, int slotIdx, int mouseButton, class_1713 clickType) {
        if (slot instanceof PatternSlot) {
            InventoryAction action = null;
            switch (clickType) {
                case field_7790: {
                    action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                    break;
                }
                case field_7794: {
                    action = mouseButton == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    break;
                }
                case field_7796: {
                    if (!this.getPlayer().method_31549().field_7477) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                    break;
                }
            }
            if (action != null) {
                PatternSlot machineSlot = (PatternSlot)slot;
                InventoryActionPacket p = new InventoryActionPacket(action, machineSlot.method_34266(), machineSlot.getMachineInv().getServerId());
                NetworkHandler.instance().sendToServer((BasePacket)p);
            }
            return;
        }
        super.method_2383(slot, slotIdx, mouseButton, clickType);
    }

    public void drawBG(class_332 guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.blit(guiGraphics, offsetX, offsetY, HEADER_BBOX);
        int scrollLevel = this.scrollbar.getCurrentScroll();
        int currentY = offsetY + 51;
        this.blit(guiGraphics, offsetX, currentY + this.visibleRows * 18, FOOTER_BBOX);
        for (int i = 0; i < this.visibleRows; ++i) {
            Row row;
            boolean firstLine = i == 0;
            boolean lastLine = i == this.visibleRows - 1;
            class_768 bbox = this.selectRowBackgroundBox(false, firstLine, lastLine);
            this.blit(guiGraphics, offsetX, currentY, bbox);
            if (scrollLevel + i < this.rows.size() && (row = this.rows.get(scrollLevel + i)) instanceof SlotsRow) {
                SlotsRow slotsRow = (SlotsRow)row;
                bbox = this.selectRowBackgroundBox(true, firstLine, lastLine);
                bbox.method_35782(22 + 18 * slotsRow.slots - 1);
                this.blit(guiGraphics, offsetX, currentY, bbox);
            }
            currentY += 18;
        }
    }

    private class_768 selectRowBackgroundBox(boolean isInvLine, boolean firstLine, boolean lastLine) {
        if (isInvLine) {
            if (firstLine) {
                return ROW_INVENTORY_TOP_BBOX;
            }
            if (lastLine) {
                return ROW_INVENTORY_BOTTOM_BBOX;
            }
            return ROW_INVENTORY_MIDDLE_BBOX;
        }
        if (firstLine) {
            return ROW_TEXT_TOP_BBOX;
        }
        if (lastLine) {
            return ROW_TEXT_BOTTOM_BBOX;
        }
        return ROW_TEXT_MIDDLE_BBOX;
    }

    public boolean method_25400(char character, int key) {
        if (character == ' ' && (this.searchOutField.method_1882().isEmpty() && this.searchOutField.method_25370() || this.searchInField.method_1882().isEmpty() && this.searchInField.method_25370())) {
            return true;
        }
        return super.method_25400(character, key);
    }

    public void clear() {
        this.byId.clear();
        this.infoMap.clear();
        this.cachedSearches.clear();
        this.refreshList();
    }

    public void postTileInfo(long id, class_2338 pos, class_5321<class_1937> dim) {
        this.infoMap.put(id, new PatternProviderInfo(pos, dim));
        this.refreshList();
    }

    public void postFullUpdate(long inventoryId, long sortBy, PatternContainerGroup group, int inventorySize, Int2ObjectMap<class_1799> slots) {
        PatternContainerRecord record = new PatternContainerRecord(inventoryId, inventorySize, sortBy, group);
        this.byId.put(inventoryId, record);
        AppEngInternalInventory inventory = record.getInventory();
        for (Int2ObjectMap.Entry entry : slots.int2ObjectEntrySet()) {
            inventory.setItemDirect(entry.getIntKey(), (class_1799)entry.getValue());
        }
        this.cachedSearches.clear();
        this.refreshList();
    }

    public void postIncrementalUpdate(long inventoryId, Int2ObjectMap<class_1799> slots) {
        PatternContainerRecord record = this.byId.get(inventoryId);
        if (record == null) {
            LOGGER.warn("Ignoring incremental update for unknown inventory id {}", (Object)inventoryId);
            return;
        }
        AppEngInternalInventory inventory = record.getInventory();
        for (Int2ObjectMap.Entry entry : slots.int2ObjectEntrySet()) {
            inventory.setItemDirect(entry.getIntKey(), (class_1799)entry.getValue());
        }
    }

    public void updateBeforeRender() {
        super.updateBeforeRender();
        this.showPatternProviders.set((Enum)((ContainerExPatternTerminal)this.field_2797).getShownProviders());
    }

    private void refreshList() {
        this.byGroup.clear();
        this.highlightBtns.forEach((k, v) -> this.method_37066((class_364)v));
        this.highlightBtns.clear();
        this.matchedStack.clear();
        this.matchedProvider.clear();
        String outputFilter = this.searchOutField.method_1882().toLowerCase();
        String inputFilter = this.searchInField.method_1882().toLowerCase();
        Set<Object> cachedSearch = this.getCacheForSearchTerm("out:" + outputFilter + "in:" + inputFilter);
        boolean rebuild = cachedSearch.isEmpty();
        for (PatternContainerRecord entry : this.byId.values()) {
            boolean found;
            if (!rebuild && !cachedSearch.contains(entry)) continue;
            boolean bl = found = outputFilter.isEmpty() && inputFilter.isEmpty();
            if (!found) {
                for (class_1799 itemStack : entry.getInventory()) {
                    boolean midRes = !outputFilter.isEmpty() ? this.itemStackMatchesSearchTerm(itemStack, outputFilter, true) : true;
                    if (!inputFilter.isEmpty() && midRes) {
                        midRes = this.itemStackMatchesSearchTerm(itemStack, inputFilter, false);
                    }
                    if (!midRes) continue;
                    found = true;
                }
            }
            if (found || entry.getSearchName().contains(outputFilter) && entry.getSearchName().contains(inputFilter)) {
                this.byGroup.put((Object)entry.getGroup(), (Object)entry);
                cachedSearch.add(entry);
                if (!entry.getSearchName().contains(outputFilter) || !entry.getSearchName().contains(inputFilter)) continue;
                this.matchedProvider.add(entry);
                continue;
            }
            cachedSearch.remove(entry);
        }
        this.groups.clear();
        this.groups.addAll(this.byGroup.keySet());
        this.groups.sort(GROUP_COMPARATOR);
        this.rows.clear();
        this.rows.ensureCapacity(this.getMaxRows());
        for (PatternContainerGroup group : this.groups) {
            this.rows.add(new GroupHeaderRow(group));
            ArrayList containers = new ArrayList(this.byGroup.get((Object)group));
            Collections.sort(containers);
            for (PatternContainerRecord container : containers) {
                PatternProviderInfo info;
                AppEngInternalInventory inventory = container.getInventory();
                if (inventory.size() > 0 && (info = this.infoMap.get(container.getServerId())) != null) {
                    HighlightButton btn = new HighlightButton();
                    btn.setMultiplier(this.playerToBlockDis(info.pos()));
                    btn.setTarget(info.pos, info.playerWorld);
                    btn.setSuccessJob(() -> {
                        if (this.getPlayer() != null && info.pos != null && info.playerWorld != null) {
                            this.getPlayer().method_7353((class_2561)class_2561.method_43469((String)"chat.ex_pattern_access_terminal.pos", (Object[])new Object[]{info.pos.method_23854(), info.playerWorld.method_29177().method_12832()}), false);
                        }
                    });
                    btn.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.extendedae.ex_pattern_access_terminal.tooltip.03")));
                    btn.setVisibility(false);
                    this.highlightBtns.put(this.rows.size(), (HighlightButton)this.method_37063((class_364)btn));
                }
                for (int offset = 0; offset < inventory.size(); offset += 9) {
                    int slots = Math.min(inventory.size() - offset, 9);
                    SlotsRow containerRow = new SlotsRow(container, offset, slots);
                    this.rows.add(containerRow);
                }
            }
        }
        this.resetScrollbar();
    }

    private double playerToBlockDis(class_2338 pos) {
        if (pos == null) {
            return 0.0;
        }
        class_2338 ps = this.getPlayer().method_23312();
        return pos.method_10262((class_2382)ps);
    }

    private void resetScrollbar() {
        this.scrollbar.setHeight(this.visibleRows * 18 - 2);
        this.scrollbar.setRange(0, this.rows.size() - this.visibleRows, 2);
    }

    private boolean itemStackMatchesSearchTerm(class_1799 itemStack, String searchTerm, boolean checkOut) {
        if (itemStack.method_7960()) {
            return false;
        }
        IPatternDetails result = null;
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof EncodedPatternItem) {
            EncodedPatternItem pattern = (EncodedPatternItem)class_17922;
            result = pattern.decode(itemStack, ((ContainerExPatternTerminal)this.field_2797).getPlayer().method_37908(), false);
        }
        if (result == null) {
            return false;
        }
        List<GenericStack> list = checkOut ? Arrays.asList(result.getOutputs()) : Arrays.stream(result.getInputs()).map(i -> i.getPossibleInputs()[0]).collect(Collectors.toList());
        for (GenericStack item : list) {
            String displayName;
            if (item == null || !(displayName = item.what().getDisplayName().getString().toLowerCase()).contains(searchTerm)) continue;
            this.matchedStack.add(itemStack);
            return true;
        }
        return false;
    }

    private Set<Object> getCacheForSearchTerm(String searchTerm) {
        Set<Object> cache;
        if (!this.cachedSearches.containsKey(searchTerm)) {
            this.cachedSearches.put(searchTerm, new HashSet());
        }
        if ((cache = this.cachedSearches.get(searchTerm)).isEmpty() && searchTerm.length() > 1) {
            cache.addAll(this.getCacheForSearchTerm(searchTerm.substring(0, searchTerm.length() - 1)));
        }
        return cache;
    }

    private void reinitialize() {
        this.method_25396().removeAll(this.field_33816);
        this.field_33816.clear();
        this.method_25426();
    }

    private void toggleTerminalStyle(SettingToggleButton<TerminalStyle> btn, boolean backwards) {
        TerminalStyle next = (TerminalStyle)btn.getNextValue(backwards);
        AEConfig.instance().setTerminalStyle(next);
        btn.set((Enum)next);
        this.reinitialize();
    }

    private int getMaxRows() {
        return this.groups.size() + this.byId.size();
    }

    private void blit(class_332 guiGraphics, int offsetX, int offsetY, class_768 srcRect) {
        class_2960 texture = AppEng.makeId((String)"textures/guis/ex_pattern_access_terminal.png");
        guiGraphics.method_25302(texture, offsetX, offsetY, srcRect.method_3321(), srcRect.method_3322(), srcRect.method_3319(), srcRect.method_3320());
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static interface Row {
    }

    record SlotsRow(PatternContainerRecord container, int offset, int slots) implements Row
    {
    }

    record GroupHeaderRow(PatternContainerGroup group) implements Row
    {
    }

    public record PatternProviderInfo(@Nullable class_2338 pos, @Nullable class_5321<class_1937> playerWorld) {
    }
}

