/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.client.model;

import appeng.client.render.model.DriveModelData;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1087;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_4590;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import org.joml.Vector3f;

public class ExDriveBakedModel
extends ForwardingBakedModel
implements FabricBakedModel {
    private final Map<class_1792, class_1087> cellModels;
    private final Map<class_1792, Mesh> bakedCells;
    private final class_1087 defaultCellModel;
    private final Mesh defaultCell;
    private final RenderContext.QuadTransform[] slotTransforms;

    public ExDriveBakedModel(class_4590 rotation, class_1087 bakedBase, Map<class_1792, class_1087> cellModels, class_1087 defaultCell) {
        this.wrapped = bakedBase;
        this.defaultCellModel = defaultCell;
        this.slotTransforms = this.buildSlotTransforms(rotation);
        this.cellModels = cellModels;
        this.bakedCells = this.convertCellModels(cellModels);
        this.defaultCell = this.convertCellModel(defaultCell);
    }

    public static void getSlotOrigin(int row, int col, int disk, Vector3f translation) {
        float xOffset = (float)(9 - col * 8) / 16.0f;
        float yOffset = (float)(13 - row * 3) / 16.0f;
        float zOffset = disk == 0 ? 0.0625f : 0.625f;
        translation.set(xOffset, yOffset, zOffset);
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        class_1792[] cells = ExDriveBakedModel.getCells(blockView, pos);
        if (cells != null) {
            for (int disk = 0; disk < 2; ++disk) {
                for (int row = 0; row < 5; ++row) {
                    for (int col = 0; col < 2; ++col) {
                        int slot = ExDriveBakedModel.getSlotIndex(row, col, disk);
                        class_1792 cell = slot < cells.length ? cells[slot] : null;
                        class_1087 cellChassisModel = this.getCellChassisModel(cell);
                        context.pushTransform(this.slotTransforms[slot]);
                        context.bakedModelConsumer().accept(cellChassisModel, null);
                        context.meshConsumer().accept(this.getCellChassisMesh(cell));
                        context.popTransform();
                    }
                }
            }
        }
    }

    private static class_1792[] getCells(class_1920 blockView, class_2338 pos) {
        if (!(blockView instanceof RenderAttachedBlockView)) {
            return null;
        }
        Object attachedData = ((RenderAttachedBlockView)blockView).getBlockEntityRenderAttachment(pos);
        if (!(attachedData instanceof DriveModelData)) {
            return null;
        }
        return ((DriveModelData)attachedData).getCells();
    }

    public boolean method_4708() {
        return false;
    }

    public class_1087 getCellChassisModel(class_1792 cell) {
        if (cell == null) {
            return this.cellModels.get(class_1802.field_8162);
        }
        class_1087 model = this.cellModels.get(cell);
        return model != null ? model : this.defaultCellModel;
    }

    public Mesh getCellChassisMesh(class_1792 cell) {
        if (cell == null) {
            return this.bakedCells.get(class_1802.field_8162);
        }
        Mesh model = this.bakedCells.get(cell);
        return model != null ? model : this.defaultCell;
    }

    private RenderContext.QuadTransform[] buildSlotTransforms(class_4590 rotation) {
        RenderContext.QuadTransform[] result = new RenderContext.QuadTransform[20];
        for (int disk = 0; disk < 2; ++disk) {
            for (int row = 0; row < 5; ++row) {
                for (int col = 0; col < 2; ++col) {
                    Vector3f translation = new Vector3f();
                    ExDriveBakedModel.getSlotOrigin(row, col, disk, translation);
                    rotation.method_22937().transform(translation);
                    result[ExDriveBakedModel.getSlotIndex((int)row, (int)col, (int)disk)] = new QuadTranslator(translation.x(), translation.y(), translation.z());
                }
            }
        }
        return result;
    }

    private static int getSlotIndex(int row, int col, int disk) {
        return row * 2 + col + disk * 10;
    }

    private Map<class_1792, Mesh> convertCellModels(Map<class_1792, class_1087> cellModels) {
        IdentityHashMap<class_1792, Mesh> result = new IdentityHashMap<class_1792, Mesh>();
        for (Map.Entry<class_1792, class_1087> entry : cellModels.entrySet()) {
            result.put(entry.getKey(), this.convertCellModel(entry.getValue()));
        }
        return result;
    }

    private Mesh convertCellModel(class_1087 bakedModel) {
        Renderer renderer = RendererAccess.INSTANCE.getRenderer();
        class_5819 random = class_5819.method_43047();
        assert (renderer != null);
        MeshBuilder meshBuilder = renderer.meshBuilder();
        QuadEmitter emitter = meshBuilder.getEmitter();
        emitter.material(renderer.materialFinder().disableDiffuse(false).ambientOcclusion(TriState.FALSE).find());
        for (int i = 0; i <= 6; ++i) {
            class_2350 face = ModelHelper.faceFromIndex((int)i);
            List quads = bakedModel.method_4707(null, face, random);
            for (class_777 quad : quads) {
                emitter.fromVanilla(quad.method_3357(), 0);
                emitter.cullFace(face);
                emitter.nominalFace(face);
                emitter.emit();
            }
        }
        return meshBuilder.build();
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    private record QuadTranslator(float x, float y, float z) implements RenderContext.QuadTransform
    {
        public boolean transform(MutableQuadView quad) {
            Vector3f target = new Vector3f();
            for (int i = 0; i < 4; ++i) {
                quad.copyPos(i, target);
                target.add(this.x, this.y, this.z);
                quad.pos(i, target);
            }
            return true;
        }
    }
}

