/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.common.parts.base;

import appeng.api.behaviors.StackExportStrategy;
import appeng.api.behaviors.StackTransferContext;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.storage.IStorageService;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.stacks.AEKey;
import appeng.core.settings.TickRates;
import appeng.parts.automation.IOBusPart;
import appeng.parts.automation.StackWorldBehaviors;
import appeng.util.prioritylist.IPartitionList;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public abstract class PartSpecialExportBus
extends IOBusPart {
    @Nullable
    protected StackExportStrategy exportStrategy;
    protected IPartitionList filter = null;

    public PartSpecialExportBus(IPartItem<?> partItem) {
        super(TickRates.ExportBus, StackWorldBehaviors.hasExportStrategyFilter(), partItem);
    }

    protected StackExportStrategy getExportStrategy() {
        if (this.exportStrategy == null) {
            class_2586 self = this.getHost().getBlockEntity();
            class_2338 fromPos = self.method_11016().method_10093(this.getSide());
            class_2350 fromSide = this.getSide().method_10153();
            this.exportStrategy = StackWorldBehaviors.createExportFacade((class_3218)((class_3218)this.getLevel()), (class_2338)fromPos, (class_2350)fromSide);
        }
        return this.exportStrategy;
    }

    protected boolean doBusWork(IGrid grid) {
        IStorageService storageService = grid.getStorageService();
        IPartitionList filter = this.createFilter();
        StackTransferContext context = this.createTransferContext(storageService, grid.getEnergyService());
        for (AEKey what : storageService.getCachedInventory().keySet()) {
            if (!filter.isListed(what)) continue;
            int transferFactory = what.getAmountPerOperation();
            long amount = (long)context.getOperationsRemaining() * (long)transferFactory;
            amount = this.getExportStrategy().transfer(context, what, amount);
            context.reduceOperationsRemaining(Math.max(1L, amount / (long)transferFactory));
            if (context.hasOperationsLeft()) continue;
            break;
        }
        return context.hasDoneWork();
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(4.0, 4.0, 12.0, 12.0, 12.0, 14.0);
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox(6.0, 6.0, 15.0, 10.0, 10.0, 16.0);
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 12.0);
    }

    protected abstract StackTransferContext createTransferContext(IStorageService var1, IEnergyService var2);

    protected abstract IPartitionList createFilter();
}

