/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.common.tileentities;

import appeng.api.behaviors.ContainerItemContext;
import appeng.api.behaviors.ContainerItemStrategies;
import appeng.api.behaviors.StackExportStrategy;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.crafting.IPatternDetails;
import appeng.api.implementations.blockentities.ICraftingMachine;
import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.api.inventories.InternalInventory;
import appeng.api.inventories.ItemTransfer;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.RelativeSide;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.blockentity.grid.AENetworkPowerBlockEntity;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.parts.automation.StackWorldBehaviors;
import appeng.util.Platform;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import com.github.glodblock.extendedae.api.CanerMode;
import com.github.glodblock.extendedae.common.EAEItemAndBlock;
import com.github.glodblock.extendedae.util.FCUtil;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class TileCaner
extends AENetworkPowerBlockEntity
implements IGridTickable,
ICraftingMachine {
    public static final int POWER_MAXIMUM_AMOUNT = 3200;
    public static final int POWER_USAGE = 80;
    private final AppEngInternalInventory container = new AppEngInternalInventory((InternalInventoryHost)this, 1, 1);
    private final GenericStackInv stuff = new GenericStackInv(this::wake, 1);
    private class_1799 target = class_1799.field_8037;
    private class_2350 ejectSide = null;
    private CanerMode mode = CanerMode.FILL;
    private AEKey emptyKey = null;

    public TileCaner(class_2338 pos, class_2680 blockState) {
        super(FCUtil.getTileType(TileCaner.class, TileCaner::new, (class_2248)EAEItemAndBlock.CANER), pos, blockState);
        this.stuff.setCapacity(AEKeyType.items(), 0L);
        this.getMainNode().setFlags(new GridFlags[0]).setIdlePowerUsage(0.0).addService(IGridTickable.class, (IGridNodeService)this);
        this.setInternalMaxPower(3200.0);
        this.setPowerSides(this.getGridConnectableSides(this.getOrientation()));
    }

    public AppEngInternalInventory getContainer() {
        return this.container;
    }

    public GenericStackInv getStuff() {
        return this.stuff;
    }

    public CanerMode getMode() {
        return this.mode;
    }

    public void setMode(CanerMode mode) {
        this.mode = mode;
    }

    @Nullable
    private ContainerItemContext getStrategy(AEKey type, class_1657 player, class_1799 target) {
        if (ContainerItemStrategies.isKeySupported((AEKey)type)) {
            return ContainerItemStrategies.findOwnedItemContext((AEKeyType)type.getType(), (class_1657)player, (class_1799)target);
        }
        return null;
    }

    public boolean isDone() {
        if (!this.target.method_7960()) {
            return this.target.method_31574(this.container.getStackInSlot(0).method_7909());
        }
        return false;
    }

    private void eject() {
        ItemTransfer target;
        if (this.field_11863 instanceof class_3218 && !this.container.getStackInSlot(0).method_7960() && this.ejectSide != null && (target = InternalInventory.wrapExternal((class_1937)this.field_11863, (class_2338)this.method_11016().method_10093(this.ejectSide), (class_2350)this.ejectSide.method_10153())) != null) {
            int startItems = this.container.getStackInSlot(0).method_7947();
            this.container.insertItem(0, target.addItems(this.container.extractItem(0, 64, false)), false);
            int endItems = this.container.getStackInSlot(0).method_7947();
            long pushed = 0L;
            long origin = 0L;
            if (this.stuff.getStack(0) != null) {
                StackExportStrategy genTarget = StackWorldBehaviors.createExportFacade((class_3218)((class_3218)this.field_11863), (class_2338)this.method_11016().method_10093(this.ejectSide), (class_2350)this.ejectSide.method_10153());
                GenericStack obj = this.stuff.getStack(0);
                origin = obj.amount();
                pushed = genTarget.push(obj.what(), origin, Actionable.MODULATE);
                this.stuff.extract(0, obj.what(), pushed, Actionable.MODULATE);
            }
            if (startItems != endItems && pushed == origin) {
                this.target = class_1799.field_8037;
                this.emptyKey = null;
            }
        }
    }

    public Set<class_2350> getGridConnectableSides(BlockOrientation orientation) {
        return EnumSet.of(orientation.getSide(RelativeSide.TOP), orientation.getSide(RelativeSide.BOTTOM));
    }

    protected void onOrientationChanged(BlockOrientation orientation) {
        super.onOrientationChanged(orientation);
        this.setPowerSides(this.getGridConnectableSides(orientation));
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 1, !this.hasJob(), true);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        this.markForUpdate();
        if (this.getInternalCurrentPower() < 3200.0) {
            this.getMainNode().ifPresent(grid -> {
                double toExtract = Math.min(80.0, this.getInternalMaxPower() - this.getInternalCurrentPower());
                double extracted = grid.getEnergyService().extractAEPower(toExtract, Actionable.MODULATE, PowerMultiplier.ONE);
                this.injectExternalPower(PowerUnits.AE, extracted, Actionable.MODULATE);
            });
        }
        if (this.mode == CanerMode.FILL) {
            this.fill();
        } else if (this.mode == CanerMode.EMPTY) {
            this.empty();
        }
        if (this.isDone()) {
            this.eject();
        }
        return TickRateModulation.FASTER;
    }

    public InternalInventory getInternalInventory() {
        return this.container;
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        if (inv == this.container) {
            this.wake();
        }
    }

    private void wake() {
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().alertDevice(node));
    }

    public void method_11007(class_2487 data) {
        super.method_11007(data);
        this.stuff.writeToChildTag(data, "stuff");
        data.method_10566("target", (class_2520)this.target.method_7953(new class_2487()));
        if (this.ejectSide != null) {
            data.method_10582("ejectSide", this.ejectSide.name());
        }
        data.method_10567("mode", (byte)this.mode.ordinal());
        if (this.emptyKey != null) {
            data.method_10566("emptyKey", (class_2520)this.emptyKey.toTag());
        }
    }

    public void loadTag(class_2487 data) {
        super.loadTag(data);
        this.stuff.readFromChildTag(data, "stuff");
        if (data.method_10545("target")) {
            this.target = class_1799.method_7915((class_2487)data.method_10562("target"));
        }
        if (data.method_10545("ejectSide")) {
            this.ejectSide = class_2350.valueOf((String)data.method_10558("ejectSide"));
        }
        if (data.method_10545("mode")) {
            this.mode = CanerMode.values()[data.method_10571("mode")];
        }
        if (data.method_10545("emptyKey")) {
            this.emptyKey = AEKey.fromTagGeneric((class_2487)data.method_10562("emptyKey"));
        }
    }

    public void addAdditionalDrops(class_1937 level, class_2338 pos, List<class_1799> drops) {
        super.addAdditionalDrops(level, pos, drops);
        GenericStack stack = this.stuff.getStack(0);
        if (stack != null) {
            stack.what().addDrops(stack.amount(), drops, level, pos);
        }
    }

    public void method_5448() {
        super.method_5448();
        this.stuff.clear();
    }

    protected boolean readFromStream(class_2540 data) {
        boolean changed = super.readFromStream(data);
        this.container.setItemDirect(0, data.method_10819());
        return changed;
    }

    protected void writeToStream(class_2540 data) {
        super.writeToStream(data);
        data.method_10793(this.container.getStackInSlot(0));
    }

    private void fill() {
        long added;
        class_1799 stack = this.container.getStackInSlot(0);
        GenericStack obj = this.stuff.getStack(0);
        if (stack.method_7960() || obj == null) {
            return;
        }
        if (!(this.field_11863 instanceof class_3218)) {
            return;
        }
        class_1657 player = Platform.getFakePlayer((class_3218)((class_3218)this.field_11863), null);
        player.method_31548().method_5447(0, stack);
        player.method_31548().method_5447(1, class_1799.field_8037);
        ContainerItemContext handler = this.getStrategy(obj.what(), player, stack);
        if (handler == null) {
            return;
        }
        if (this.getInternalCurrentPower() >= 80.0 && (added = handler.insert(obj.what(), obj.amount(), Actionable.MODULATE)) > 0L) {
            this.stuff.extract(0, obj.what(), added, Actionable.MODULATE);
            if (!player.method_31548().method_5438(0).method_7960()) {
                this.container.setItemDirect(0, player.method_31548().method_5438(0).method_7972());
            } else {
                this.container.setItemDirect(0, player.method_31548().method_5438(1).method_7972());
            }
            this.extractAEPower(80.0, Actionable.MODULATE, PowerMultiplier.CONFIG);
        }
    }

    private void empty() {
        long canAdd;
        long toAdd;
        class_1799 stack = this.container.getStackInSlot(0);
        GenericStack obj = this.stuff.getStack(0);
        if (stack.method_7960()) {
            return;
        }
        if (!(this.field_11863 instanceof class_3218)) {
            return;
        }
        GenericStack contents = this.emptyKey != null ? ContainerItemStrategies.getContainedStack((class_1799)stack, (AEKeyType)this.emptyKey.getType()) : ContainerItemStrategies.getContainedStack((class_1799)stack);
        if (contents == null) {
            return;
        }
        if (obj != null && !obj.what().equals(contents.what())) {
            return;
        }
        class_1657 player = Platform.getFakePlayer((class_3218)((class_3218)this.field_11863), null);
        player.method_31548().method_5447(0, stack);
        player.method_31548().method_5447(1, class_1799.field_8037);
        ContainerItemContext handler = this.getStrategy(contents.what(), player, stack);
        if (handler == null) {
            return;
        }
        if (this.getInternalCurrentPower() >= 80.0 && (toAdd = handler.extract(contents.what(), contents.amount(), Actionable.SIMULATE)) > 0L && (canAdd = this.stuff.insert(0, contents.what(), toAdd, Actionable.SIMULATE)) == toAdd) {
            handler.extract(contents.what(), canAdd, Actionable.MODULATE);
            this.stuff.insert(0, contents.what(), canAdd, Actionable.MODULATE);
            if (!player.method_31548().method_5438(0).method_7960()) {
                this.container.setItemDirect(0, player.method_31548().method_5438(0).method_7972());
            } else {
                this.container.setItemDirect(0, player.method_31548().method_5438(1).method_7972());
            }
            this.extractAEPower(80.0, Actionable.MODULATE, PowerMultiplier.CONFIG);
        }
    }

    private boolean hasJob() {
        if (this.mode == CanerMode.FILL) {
            return this.stuff.getStack(0) != null && !this.container.getStackInSlot(0).method_7960();
        }
        if (this.mode == CanerMode.EMPTY) {
            return !this.container.getStackInSlot(0).method_7960();
        }
        return false;
    }

    public PatternContainerGroup getCraftingMachineInfo() {
        class_2561 name = this.method_16914() ? this.method_5797() : EAEItemAndBlock.CANER.method_8389().method_7848();
        return new PatternContainerGroup(AEItemKey.of((class_1935)EAEItemAndBlock.CANER), name, List.of());
    }

    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputs, class_2350 ejectionDirection) {
        if (patternDetails instanceof AEProcessingPattern && this.stuff.getStack(0) == null && this.container.getStackInSlot(0).method_7960()) {
            if (this.mode == CanerMode.FILL) {
                if (inputs.length == 2 && inputs[0].getFirstEntry() != null && inputs[1].getFirstEntry() != null) {
                    boolean fail;
                    Object2LongMap.Entry obj = inputs[0].getFirstEntry();
                    Object2LongMap.Entry cnt = inputs[1].getFirstEntry();
                    GenericStack rst = patternDetails.getPrimaryOutput();
                    if (obj.getKey() instanceof AEItemKey) {
                        obj = inputs[1].getFirstEntry();
                        cnt = inputs[0].getFirstEntry();
                    }
                    if (!(cnt.getKey() instanceof AEItemKey) || cnt.getLongValue() != 1L) {
                        return false;
                    }
                    if (!(rst.what() instanceof AEItemKey) || rst.amount() != 1L) {
                        return false;
                    }
                    this.stuff.setStack(0, new GenericStack((AEKey)obj.getKey(), obj.getLongValue()));
                    this.container.setItemDirect(0, ((AEItemKey)cnt.getKey()).toStack());
                    boolean bl = fail = this.stuff.getStack(0) == null || this.stuff.getStack(0).amount() != obj.getLongValue();
                    if (this.container.getStackInSlot(0).method_7960()) {
                        fail = true;
                    }
                    if (fail) {
                        this.stuff.setStack(0, null);
                        this.container.setItemDirect(0, class_1799.field_8037);
                        return false;
                    }
                    this.target = ((AEItemKey)rst.what()).toStack();
                    this.ejectSide = ejectionDirection;
                    return true;
                }
            } else if (this.mode == CanerMode.EMPTY && inputs.length == 1 && patternDetails.getOutputs().length == 2 && inputs[0].getFirstEntry() != null) {
                boolean fail;
                Object2LongMap.Entry cnt = inputs[0].getFirstEntry();
                GenericStack obj = patternDetails.getOutputs()[0];
                GenericStack rst = patternDetails.getOutputs()[1];
                if (obj.what() instanceof AEItemKey) {
                    obj = patternDetails.getOutputs()[1];
                    rst = patternDetails.getOutputs()[0];
                }
                if (!(cnt.getKey() instanceof AEItemKey) || cnt.getLongValue() != 1L) {
                    return false;
                }
                if (!(rst.what() instanceof AEItemKey) || rst.amount() != 1L) {
                    return false;
                }
                this.container.setItemDirect(0, ((AEItemKey)cnt.getKey()).toStack());
                boolean bl = fail = this.container.getStackInSlot(0).method_7960() || obj == null;
                if (!fail) {
                    this.target = ((AEItemKey)rst.what()).toStack();
                    this.emptyKey = obj.what();
                    this.ejectSide = ejectionDirection;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean acceptsPlans() {
        return true;
    }
}

