/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork;

import com.simibubi.create.content.redstone.analogLever.AnalogLeverBlockEntity;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.PonderRegistrationHelper;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.element.InputWindowElement;
import com.simibubi.create.foundation.utility.Pointing;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2457;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import org.valkyrienskies.clockwork.ClockworkBlocks;
import org.valkyrienskies.clockwork.ClockworkItems;

public class ClockworkPonderScenes {
    static final PonderRegistrationHelper HELPER = new PonderRegistrationHelper("vs_clockwork");

    public static void init() {
        HELPER.forComponents(new ItemProviderEntry[]{ClockworkItems.WANDERWAND, ClockworkBlocks.PHYSICS_INFUSER}).addStoryBoard("wanderwand", ClockworkPonderScenes::createShip);
        HELPER.forComponents(new ItemProviderEntry[]{ClockworkBlocks.REDSTONE_RESISTOR}).addStoryBoard("resistor", ClockworkPonderScenes::redstoneResistor);
        HELPER.forComponents(new ItemProviderEntry[]{ClockworkBlocks.ALT_METER}).addStoryBoard("alt_meter", ClockworkPonderScenes::altMeter);
        HELPER.forComponents(new ItemProviderEntry[]{ClockworkBlocks.FLAP_BEARING, ClockworkBlocks.FLAP}).addStoryBoard("flap_bearing", ClockworkPonderScenes::flap);
    }

    private static void propagator(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("propagator_1", "Propegate your torque");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.setSceneOffsetY(-1.0f);
        scene.idle(15);
        Selection mech_bearing = util.select.position(2, 3, 2);
        class_2338 mech_bearing_pos = util.grid.at(2, 3, 2);
        Selection mech_bearing_contrap = util.select.position(2, 4, 2);
        Selection prop_shaft = util.select.fromTo(3, 3, 2, 3, 4, 2);
        Selection prop_part1 = util.select.position(3, 2, 2);
        Selection prop_part2 = util.select.position(3, 5, 2);
        Selection cog = util.select.position(2, 2, 2);
        Selection boxes = util.select.fromTo(2, 1, 2, 3, 1, 2);
        scene.world.showSection(cog, class_2350.field_11033);
        scene.world.showSection(boxes, class_2350.field_11033);
        scene.idle(15);
        scene.world.showSection(mech_bearing, class_2350.field_11033);
        scene.world.rotateBearing(mech_bearing_pos, -360.0f, 180);
        ElementLink contraption_mech = scene.world.showIndependentSection(mech_bearing_contrap, class_2350.field_11033);
        scene.world.moveSection(contraption_mech, util.vector.of(0.0, 0.0, 0.0), 0);
        scene.world.rotateSection(contraption_mech, 0.0, -360.0, 0.0, 180);
        scene.idle(15);
        scene.world.showSection(prop_part1, class_2350.field_11033);
        scene.world.showSection(prop_shaft, class_2350.field_11033);
        scene.world.setKineticSpeed(prop_shaft, 64.0f);
        ElementLink contraption_prop = scene.world.showIndependentSection(prop_part2, class_2350.field_11033);
        scene.world.moveSection(contraption_prop, util.vector.of(0.0, 0.0, 0.0), 0);
        scene.world.rotateSection(contraption_prop, 0.0, 360.0, 0.0, 180);
        scene.idle(15);
        scene.idle(148);
    }

    private static void propagator2(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("propagator_2", "Propegate your torque");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.setSceneOffsetY(-1.0f);
        scene.idle(15);
        Selection propulsor = util.select.position(2, 1, 2);
        Selection center_shaft = util.select.position(2, 2, 2);
        Selection box = util.select.fromTo(2, 3, 0, 2, 3, 4);
        Selection shaft_ex_1 = util.select.fromTo(2, 3, 0, 2, 3, 1);
        Selection shaft_ex_2 = util.select.fromTo(2, 3, 3, 2, 3, 4);
        scene.world.showSection(propulsor, class_2350.field_11033);
        scene.world.showSection(center_shaft, class_2350.field_11033);
        scene.world.setKineticSpeed(center_shaft, 16.0f);
        scene.world.setKineticSpeed(shaft_ex_1, 16.0f);
        scene.world.setKineticSpeed(shaft_ex_2, -16.0f);
        ElementLink contraption_ex = scene.world.showIndependentSection(box, class_2350.field_11033);
        scene.world.moveSection(contraption_ex, util.vector.of(0.0, 0.0, 0.0), 0);
        scene.world.rotateSection(contraption_ex, 0.0, 180.0, 0.0, 360);
        scene.idle(148);
    }

    private static void flap(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("flap_bearing", "Steering planes");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.setSceneOffsetY(-1.0f);
        scene.idle(15);
        Selection bearing = util.select.fromTo(2, 1, 2, 2, 1, 4);
        Selection flap_ship = util.select.position(2, 1, 1);
        ElementLink contraption = scene.world.showIndependentSection(flap_ship, class_2350.field_11033);
        scene.world.moveSection(contraption, util.vector.of(0.0, 0.0, 0.0), 0);
        Selection red1 = util.select.fromTo(0, 1, 2, 1, 1, 2);
        Selection red2 = util.select.fromTo(4, 1, 2, 3, 1, 2);
        scene.world.showSection(bearing, class_2350.field_11033);
        scene.idle(15);
        scene.idle(45);
        scene.world.showSection(red1, class_2350.field_11033);
        scene.world.showSection(red2, class_2350.field_11033);
        scene.idle(25);
        scene.world.toggleRedstonePower(red1);
        scene.world.rotateSection(contraption, 0.0, 0.0, 25.0, 17);
        scene.idle(35);
        scene.world.toggleRedstonePower(red1);
        scene.world.toggleRedstonePower(red2);
        scene.world.rotateSection(contraption, 0.0, 0.0, -50.0, 17);
        scene.idle(35);
        scene.idle(148);
    }

    private static void altMeter(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("alt_meter", "Measure height");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.setSceneOffsetY(-1.0f);
        scene.idle(15);
        Selection ship = util.select.fromTo(0, 1, 0, 4, 3, 4);
        ElementLink contraption = scene.world.showIndependentSection(ship, class_2350.field_11033);
        scene.world.moveSection(contraption, util.vector.of(0.0, 0.0, 0.0), 0);
        scene.idle(15);
        scene.overlay.showText(40).attachKeyFrame().text("Configure Altitude Meter to desired height").placeNearTarget().pointAt(util.vector.blockSurface(util.grid.at(0, 2, 0), class_2350.field_11039));
        scene.idle(40);
        scene.world.moveSection(contraption, util.vector.of(0.0, 2.0, 0.0), 20);
        scene.idle(15);
        scene.overlay.showText(40).attachKeyFrame().text("Redstone output will trigger at configured height").placeNearTarget().pointAt(util.vector.blockSurface(util.grid.at(0, 4, 0), class_2350.field_11039));
        scene.world.toggleRedstonePower(ship);
        scene.idle(40);
        scene.idle(148);
    }

    private static void createShip(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("wanderwand", "Creating ships using the Wanderwand");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.setSceneOffsetY(-1.0f);
        scene.idle(15);
        Selection lever = util.select.position(0, 0, 0);
        Selection ship = util.select.fromTo(0, 1, 1, 4, 3, 3);
        ElementLink contraption = scene.world.showIndependentSection(ship, class_2350.field_11033);
        scene.world.moveSection(contraption, util.vector.of(0.0, 0.0, 0.0), 0);
        scene.idle(15);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(0, 2, 1), Pointing.UP).withItem(ClockworkItems.WANDERWAND.asStack()).rightClick(), 40);
        scene.idle(6);
        scene.effects.indicateSuccess(util.grid.at(0, 2, 1));
        scene.idle(45);
        scene.overlay.showControls(new InputWindowElement(util.vector.blockSurface(util.grid.at(4, 3, 4), class_2350.field_11033), Pointing.DOWN).withItem(ClockworkItems.WANDERWAND.asStack()).rightClick(), 40);
        scene.idle(6);
        class_238 bb = new class_238(util.grid.at(0, 2, 1));
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.BLUE, (Object)lever, bb, 1);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.BLUE, (Object)lever, bb.method_1012(4.0, 1.0, 2.0), 70);
        scene.idle(70);
        scene.world.setBlock(util.grid.at(0, 1, 0), ClockworkBlocks.PHYSICS_INFUSER.getDefaultState(), false);
        scene.world.showSection(util.select.position(0, 1, 0), class_2350.field_11043);
        scene.idle(20);
        scene.overlay.showText(40).attachKeyFrame().text("Place the wand in the Physics Infuser").placeNearTarget().pointAt(util.vector.blockSurface(util.grid.at(0, 2, 0), class_2350.field_11039));
        scene.overlay.showControls(new InputWindowElement(util.vector.blockSurface(util.grid.at(0, 2, 0), class_2350.field_11033), Pointing.DOWN).withItem(ClockworkItems.WANDERWAND.asStack()).rightClick(), 40);
        scene.idle(50);
        scene.overlay.showText(40).attachKeyFrame().text("Or use the Gravitron").placeNearTarget().pointAt(util.vector.blockSurface(util.grid.at(2, 2, 2), class_2350.field_11039));
        scene.overlay.showControls(new InputWindowElement(util.vector.blockSurface(util.grid.at(2, 2, 2), class_2350.field_11033), Pointing.DOWN).withItem(ClockworkItems.GRAVITRON.asStack()).rightClick(), 40);
        scene.idle(50);
        scene.world.moveSection(contraption, util.vector.of(0.0, -0.1, 0.0), 4);
        scene.idle(4);
        scene.world.moveSection(contraption, util.vector.of(0.0, -0.1, 0.0), 3);
        scene.idle(3);
        scene.world.moveSection(contraption, util.vector.of(0.0, -0.1, 0.0), 2);
        scene.idle(2);
        scene.world.moveSection(contraption, util.vector.of(0.0, -0.7, 0.0), 10);
        scene.idle(14);
        scene.world.moveSection(contraption, util.vector.of(0.0, 0.015, 0.0), 3);
        scene.idle(3);
        scene.world.moveSection(contraption, util.vector.of(0.0, -0.01, 0.0), 2);
        scene.idle(2);
        scene.world.moveSection(contraption, util.vector.of(0.0, -0.005, 0.0), 1);
        scene.idle(20);
        scene.overlay.showText(40).attachKeyFrame().text("This Ship is now affected by physics!").placeNearTarget().pointAt(util.vector.blockSurface(util.grid.at(2, 0, 3), class_2350.field_11039));
        scene.idle(148);
    }

    private static void redstoneResistor(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("resistor", "Using the Redstone Resisitor");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.setSceneOffsetY(-1.0f);
        scene.idle(15);
        Selection lever = util.select.position(2, 1, 1);
        Selection resistor = util.select.position(2, 1, 3);
        Selection redstone = util.select.position(2, 1, 2);
        Selection rot1 = util.select.fromTo(0, 1, 3, 1, 1, 3);
        Selection rot2 = util.select.fromTo(3, 1, 3, 4, 1, 3);
        scene.world.showSection(rot2, class_2350.field_11033);
        scene.idle(5);
        scene.world.showSection(resistor, class_2350.field_11033);
        scene.idle(5);
        scene.world.showSection(rot1, class_2350.field_11033);
        scene.idle(45);
        scene.overlay.showText(50).attachKeyFrame().text("16 RPM").placeNearTarget().pointAt(util.vector.blockSurface(util.grid.at(4, 1, 3), class_2350.field_11039));
        scene.idle(60);
        scene.world.showSection(lever, class_2350.field_11033);
        scene.idle(5);
        scene.world.showSection(redstone, class_2350.field_11033);
        scene.idle(15);
        class_2338 leverPos = util.grid.at(2, 1, 1);
        class_2758 power = class_2457.field_11432;
        class_243 leverVec = util.vector.centerOf(leverPos).method_1031(0.0, -0.25, 0.0);
        scene.overlay.showControls(new InputWindowElement(leverVec, Pointing.DOWN).rightClick(), 40);
        scene.idle(45);
        scene.world.modifyBlockEntityNBT(lever, AnalogLeverBlockEntity.class, nbt -> nbt.method_10569("State", 5));
        scene.world.modifyBlock(util.grid.at(2, 1, 2), s -> (class_2680)s.method_11657((class_2769)power, (Comparable)Integer.valueOf(5)), false);
        scene.effects.indicateRedstone(util.grid.at(2, 1, 2));
        scene.world.setKineticSpeed(rot1, -10.67f);
        scene.overlay.showText(50).attachKeyFrame().text("Speed will go down depending on redstone level").placeNearTarget().pointAt(util.vector.blockSurface(util.grid.at(2, 1, 2), class_2350.field_11039));
        scene.idle(60);
        scene.overlay.showText(50).attachKeyFrame().text("10.67 RPM").placeNearTarget().pointAt(util.vector.blockSurface(util.grid.at(0, 1, 3), class_2350.field_11039));
        scene.idle(60);
        scene.world.modifyBlockEntityNBT(lever, AnalogLeverBlockEntity.class, nbt -> nbt.method_10569("State", 10));
        scene.world.modifyBlock(util.grid.at(2, 1, 2), s -> (class_2680)s.method_11657((class_2769)power, (Comparable)Integer.valueOf(10)), false);
        scene.effects.indicateRedstone(util.grid.at(2, 1, 2));
        scene.world.setKineticSpeed(rot1, -5.33f);
        scene.overlay.showText(50).attachKeyFrame().text("5.33 RPM").placeNearTarget().pointAt(util.vector.blockSurface(util.grid.at(0, 1, 3), class_2350.field_11039));
        scene.idle(45);
        scene.world.modifyBlockEntityNBT(lever, AnalogLeverBlockEntity.class, nbt -> nbt.method_10569("State", 15));
        scene.world.modifyBlock(util.grid.at(2, 1, 2), s -> (class_2680)s.method_11657((class_2769)power, (Comparable)Integer.valueOf(15)), false);
        scene.effects.indicateRedstone(util.grid.at(2, 1, 2));
        scene.world.setKineticSpeed(rot1, 0.0f);
        scene.overlay.showText(50).attachKeyFrame().text("0 RPM").placeNearTarget().pointAt(util.vector.blockSurface(util.grid.at(0, 1, 3), class_2350.field_11039));
        scene.idle(45);
        scene.idle(148);
    }
}

