/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.phys.slicker;

import com.fasterxml.jackson.dataformat.cbor.databind.CBORMapper;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.IControlContraption;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.contraptions.TranslatingContraption;
import com.simibubi.create.content.contraptions.bearing.BearingContraption;
import com.simibubi.create.content.contraptions.bearing.StabilizedContraption;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.gantry.GantryContraption;
import com.simibubi.create.content.contraptions.piston.LinearActuatorBlockEntity;
import com.simibubi.create.content.contraptions.piston.PistonContraption;
import com.simibubi.create.content.contraptions.pulley.PulleyContraption;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_5431;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.content.contraptions.phys.slicker.SlickerBlock;
import org.valkyrienskies.clockwork.mixin.accessors.IMixinPistonContraption;
import org.valkyrienskies.clockwork.util.ClockworkConstants;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.apigame.constraints.VSAttachmentConstraint;
import org.valkyrienskies.core.apigame.constraints.VSConstraint;
import org.valkyrienskies.core.apigame.constraints.VSFixedOrientationConstraint;
import org.valkyrienskies.core.impl.util.serialization.VSJacksonUtil;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.mixin.mod_compat.create.blockentity.IMixinMechanicalBearingTileEntity;
import org.valkyrienskies.mod.mixinducks.mod_compat.create.IMixinControlledContraptionEntity;
import org.valkyrienskies.mod.mixinducks.mod_compat.create.MixinAbstractContraptionEntityDuck;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b \u0010!J+\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J'\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0019\u0010\u0018\u001a\u00020\b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u0019J\u0017\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u0019R\"\u0010\u001c\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001c\u0010\u0017\"\u0004\b\u001e\u0010\u001f\u00a8\u0006#"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/phys/slicker/SlickerMovementBehavior;", "Lcom/simibubi/create/content/contraptions/behaviour/MovementBehaviour;", "Lcom/simibubi/create/content/contraptions/behaviour/MovementContext;", "context", "Lorg/joml/Vector3dc;", "ship1Pos", "Lorg/joml/Quaterniond;", "ship1Rot", "", "doUpdateConstraint", "(Lcom/simibubi/create/content/contraptions/behaviour/MovementContext;Lorg/joml/Vector3dc;Lorg/joml/Quaterniond;)V", "", "getAssembleNextTick", "(Lcom/simibubi/create/content/contraptions/behaviour/MovementContext;)Z", "Lnet/minecraft/class_2350$class_2351;", "getFacingAxis", "(Lcom/simibubi/create/content/contraptions/behaviour/MovementContext;)Lnet/minecraft/class_2350$class_2351;", "Lnet/minecraft/class_243;", "oldMotion", "motion", "onSpeedChanged", "(Lcom/simibubi/create/content/contraptions/behaviour/MovementContext;Lnet/minecraft/class_243;Lnet/minecraft/class_243;)V", "renderAsNormalBlockEntity", "()Z", "startMoving", "(Lcom/simibubi/create/content/contraptions/behaviour/MovementContext;)V", "stopMoving", "tick", "isStopped", "Z", "setStopped", "(Z)V", "<init>", "()V", "Companion", "clockwork"})
public final class SlickerMovementBehavior
implements MovementBehaviour {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isStopped = true;
    @NotNull
    private static final CBORMapper mapper = VSJacksonUtil.INSTANCE.getDefaultMapper();
    public static final double DISTANCE_BUFFER = 1.05;

    public final boolean isStopped() {
        return this.isStopped;
    }

    public final void setStopped(boolean bl) {
        this.isStopped = bl;
    }

    public boolean renderAsNormalBlockEntity() {
        return true;
    }

    public void tick(@NotNull MovementContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.world == null || context.world.field_9236) {
            return;
        }
        class_2487 class_24872 = context.blockEntityData.method_10562(ClockworkConstants.Nbt.INSTANCE.getCONDENSED_DATA());
        Intrinsics.checkNotNullExpressionValue((Object)class_24872, (String)"getCompound(...)");
        class_2487 data = class_24872;
        if (!data.method_33133() && data.method_10545(ClockworkConstants.Nbt.INSTANCE.getATTACHMENT_CONSTRAINT()) && data.method_10545(ClockworkConstants.Nbt.INSTANCE.getORIENTATION_CONSTRAINT())) {
            if (!this.isStopped) {
                this.doUpdateConstraint(context, null, null);
            }
        } else {
            Comparable comparable = context.state.method_11654((class_2769)SlickerBlock.Companion.getEXTENDED());
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
            if (((Boolean)comparable).booleanValue()) {
                context.blockEntityData.method_10566(ClockworkConstants.Nbt.INSTANCE.getCONDENSED_DATA(), (class_2520)new class_2487());
                class_1937 class_19372 = context.world;
                Intrinsics.checkNotNull((Object)class_19372, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                class_3218 class_32182 = (class_3218)class_19372;
                class_2338 class_23382 = context.localPos;
                Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"localPos");
                Vector3dc vector3dc = (Vector3dc)VectorConversionsMCKt.toJOMLD((class_2382)((class_2382)class_23382));
                Object r = context.rotation.apply(class_243.method_24954((class_2382)((class_2350)context.state.method_11654((class_2769)class_2318.field_10927)).method_10163()));
                Intrinsics.checkNotNullExpressionValue(r, (String)"apply(...)");
                Vector3dc vector3dc2 = (Vector3dc)VectorConversionsMCKt.toJOML((class_243)((class_243)r));
                class_2487 class_24873 = context.blockEntityData.method_10562(ClockworkConstants.Nbt.INSTANCE.getCONDENSED_DATA());
                Intrinsics.checkNotNullExpressionValue((Object)class_24873, (String)"getCompound(...)");
                Companion.isAttachedToShipOrWorld(true, class_32182, vector3dc, vector3dc2, class_24873);
            }
        }
    }

    @Nullable
    public final class_2350.class_2351 getFacingAxis(@NotNull MovementContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        class_2350.class_2351 axis = null;
        if (context.contraption instanceof PistonContraption) {
            Contraption contraption = context.contraption;
            Intrinsics.checkNotNull((Object)contraption, (String)"null cannot be cast to non-null type org.valkyrienskies.clockwork.mixin.accessors.IMixinPistonContraption");
            axis = ((IMixinPistonContraption)contraption).getOrientation().method_10166();
        }
        if (context.contraption instanceof PulleyContraption) {
            axis = class_2350.class_2351.field_11052;
        }
        if (context.contraption instanceof GantryContraption) {
            Contraption contraption = context.contraption;
            Intrinsics.checkNotNull((Object)contraption, (String)"null cannot be cast to non-null type com.simibubi.create.content.contraptions.gantry.GantryContraption");
            axis = ((GantryContraption)contraption).getFacing().method_10166();
        }
        return axis;
    }

    public void onSpeedChanged(@NotNull MovementContext context, @NotNull class_243 oldMotion, @NotNull class_243 motion) {
        float axisMotion;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)oldMotion, (String)"oldMotion");
        Intrinsics.checkNotNullParameter((Object)motion, (String)"motion");
        class_2350.class_2351 axis = this.getFacingAxis(context);
        this.isStopped = axis != null ? (double)(axisMotion = Math.abs(VecHelper.getCoordinate((class_243)motion, (class_2350.class_2351)axis))) < 0.001 : Intrinsics.areEqual((Object)motion, (Object)class_243.field_1353);
        Vector3d a = new Vector3d(1.0, 45.0, 1.0);
    }

    private final boolean getAssembleNextTick(MovementContext context) {
        boolean result = false;
        if (context.contraption.entity instanceof ControlledContraptionEntity) {
            if (context.contraption instanceof TranslatingContraption) {
                AbstractContraptionEntity abstractContraptionEntity = context.contraption.entity;
                Intrinsics.checkNotNull((Object)abstractContraptionEntity, (String)"null cannot be cast to non-null type org.valkyrienskies.mod.mixinducks.mod_compat.create.IMixinControlledContraptionEntity");
                IControlContraption iControlContraption = ((IMixinControlledContraptionEntity)abstractContraptionEntity).grabController();
                Intrinsics.checkNotNull((Object)iControlContraption, (String)"null cannot be cast to non-null type com.simibubi.create.content.contraptions.piston.LinearActuatorBlockEntity");
                result = ((LinearActuatorBlockEntity)iControlContraption).assembleNextTick;
            }
            if (context.contraption instanceof BearingContraption || context.contraption instanceof StabilizedContraption) {
                AbstractContraptionEntity abstractContraptionEntity = context.contraption.entity;
                Intrinsics.checkNotNull((Object)abstractContraptionEntity, (String)"null cannot be cast to non-null type org.valkyrienskies.mod.mixinducks.mod_compat.create.IMixinControlledContraptionEntity");
                IControlContraption iControlContraption = ((IMixinControlledContraptionEntity)abstractContraptionEntity).grabController();
                Intrinsics.checkNotNull((Object)iControlContraption, (String)"null cannot be cast to non-null type org.valkyrienskies.mod.mixin.mod_compat.create.blockentity.IMixinMechanicalBearingTileEntity");
                result = ((IMixinMechanicalBearingTileEntity)iControlContraption).isAssembleNextTick();
            }
        }
        return result;
    }

    public void startMoving(@Nullable MovementContext context) {
        this.isStopped = false;
    }

    public void stopMoving(@NotNull MovementContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.isStopped = true;
        Vector3d position = null;
        Quaterniond quaterniond = null;
        class_2487 class_24872 = context.blockEntityData.method_10562(ClockworkConstants.Nbt.INSTANCE.getCONDENSED_DATA());
        Intrinsics.checkNotNullExpressionValue((Object)class_24872, (String)"getCompound(...)");
        class_2487 extraData = class_24872;
        double distance = 1.05;
        if (extraData.method_10545(ClockworkConstants.Nbt.INSTANCE.getSHIP_SLICKER_DISTANCE())) {
            distance = extraData.method_10574(ClockworkConstants.Nbt.INSTANCE.getSHIP_SLICKER_DISTANCE());
        }
        class_2350 myDir = (class_2350)context.state.method_11654((class_2769)class_2318.field_10927);
        class_243 class_2432 = class_243.method_24954((class_2382)myDir.method_10163());
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"atLowerCornerOf(...)");
        Vector3d vector3d = VectorConversionsMCKt.toJOML((class_243)class_2432).mul(0.5);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"mul(...)");
        class_243 myDirNormal = VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)vector3d));
        if (!this.getAssembleNextTick(context)) {
            Comparable comparable = context.state.method_11654((class_2769)class_2741.field_12484);
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
            if (((Boolean)comparable).booleanValue()) {
                extraData.method_10556(ClockworkConstants.Nbt.INSTANCE.getSHIP_STICKER_ALREADY_POWERED(), true);
            }
            AbstractContraptionEntity abstractContraptionEntity = context.contraption.entity;
            Intrinsics.checkNotNull((Object)abstractContraptionEntity, (String)"null cannot be cast to non-null type org.valkyrienskies.mod.mixinducks.mod_compat.create.MixinAbstractContraptionEntityDuck");
            StructureTransform structureTransform = ((MixinAbstractContraptionEntityDuck)abstractContraptionEntity).getStructureTransform();
            Intrinsics.checkNotNullExpressionValue((Object)structureTransform, (String)"getStructureTransform(...)");
            StructureTransform structureTransform2 = structureTransform;
            class_243 class_2433 = class_243.method_24953((class_2382)((class_2382)structureTransform2.apply(context.localPos))).method_1019(structureTransform2.applyWithoutOffsetUncentered(myDirNormal));
            Intrinsics.checkNotNullExpressionValue((Object)class_2433, (String)"add(...)");
            position = VectorConversionsMCKt.toJOML((class_243)class_2433);
            if (distance < 1.05) {
                class_243 class_2434 = structureTransform2.applyWithoutOffsetUncentered(class_243.method_24954((class_2382)myDir.method_10163()).method_1021(distance / (double)-1 + 1.05));
                Intrinsics.checkNotNullExpressionValue((Object)class_2434, (String)"applyWithoutOffsetUncentered(...)");
                position.add((Vector3dc)VectorConversionsMCKt.toJOML((class_243)class_2434));
            }
            if (context.contraption instanceof BearingContraption) {
                class_243 class_2435 = class_243.method_24954((class_2382)((class_2382)structureTransform2.applyWithoutOffset(context.localPos)));
                Intrinsics.checkNotNullExpressionValue((Object)class_2435, (String)"atLowerCornerOf(...)");
                Vector3d vector3d2 = VectorConversionsMCKt.toJOML((class_243)class_2435);
                class_243 class_2436 = class_243.method_24954((class_2382)((class_2382)context.localPos));
                Intrinsics.checkNotNullExpressionValue((Object)class_2436, (String)"atLowerCornerOf(...)");
                Quaterniond quaterniond2 = vector3d2.rotationTo((Vector3dc)VectorConversionsMCKt.toJOML((class_243)class_2436), new Quaterniond());
                Intrinsics.checkNotNullExpressionValue((Object)quaterniond2, (String)"rotationTo(...)");
                Quaterniond tempQuat = quaterniond2;
                quaterniond = new Quaterniond();
                tempQuat.mul(((VSFixedOrientationConstraint)mapper.readValue(extraData.method_10547(ClockworkConstants.Nbt.INSTANCE.getORIENTATION_CONSTRAINT()), VSFixedOrientationConstraint.class)).getLocalRot0(), quaterniond);
            }
        }
        if (!extraData.method_33133() && extraData.method_10545(ClockworkConstants.Nbt.INSTANCE.getATTACHMENT_CONSTRAINT_ID()) && extraData.method_10545(ClockworkConstants.Nbt.INSTANCE.getORIENTATION_CONSTRAINT_ID())) {
            this.doUpdateConstraint(context, (Vector3dc)position, quaterniond);
        }
    }

    private final void doUpdateConstraint(MovementContext context, Vector3dc ship1Pos, Quaterniond ship1Rot) {
        if (context.world.field_9236) {
            return;
        }
        Ship ship1 = null;
        Ship ship2 = null;
        double distance = 1.05;
        Vector3d realShip1Pos = (Vector3d)ship1Pos;
        Quaterniond realShip1Rot = ship1Rot;
        class_2487 class_24872 = context.blockEntityData.method_10562(ClockworkConstants.Nbt.INSTANCE.getCONDENSED_DATA());
        Intrinsics.checkNotNullExpressionValue((Object)class_24872, (String)"getCompound(...)");
        class_2487 extraData = class_24872;
        if (extraData.method_10545(ClockworkConstants.Nbt.INSTANCE.getATTACHMENT_CONSTRAINT_ID()) && extraData.method_10545(ClockworkConstants.Nbt.INSTANCE.getORIENTATION_CONSTRAINT_ID())) {
            Vector3d ship2Pos = null;
            Quaterniond ship2Rot = null;
            byte[] attachConstraintData = extraData.method_10547(ClockworkConstants.Nbt.INSTANCE.getATTACHMENT_CONSTRAINT());
            VSAttachmentConstraint attachConstraint = (VSAttachmentConstraint)mapper.readValue(attachConstraintData, VSAttachmentConstraint.class);
            byte[] orientationConstraintData = extraData.method_10547(ClockworkConstants.Nbt.INSTANCE.getORIENTATION_CONSTRAINT());
            VSFixedOrientationConstraint orientationConstraint = (VSFixedOrientationConstraint)mapper.readValue(orientationConstraintData, VSFixedOrientationConstraint.class);
            distance = attachConstraint.getFixedDistance();
            ship1 = VSGameUtilsKt.getShipObjectWorld((class_1937)context.world).getAllShips().getById(attachConstraint.getShipId0());
            ship2 = VSGameUtilsKt.getShipObjectWorld((class_1937)context.world).getAllShips().getById(attachConstraint.getShipId1());
            ship2Pos = new Vector3d(attachConstraint.getLocalPos1());
            ship2Rot = new Quaterniond(orientationConstraint.getLocalRot1());
            if (ship1 == null && ship2 == null) {
                return;
            }
            class_2350 myDir = (class_2350)context.state.method_11654((class_2769)class_2318.field_10927);
            if (ship1 != null && ship2 != null) {
                class_243 class_2432 = class_243.method_24954((class_2382)myDir.method_10163());
                Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"atLowerCornerOf(...)");
                Vector3d vector3d = VectorConversionsMCKt.toJOML((class_243)class_2432).mul(0.5);
                Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"mul(...)");
                v3 = VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)vector3d));
            } else {
                class_243 myDirNormal;
                class_243 class_2433 = class_243.method_24954((class_2382)myDir.method_10163());
                Intrinsics.checkNotNullExpressionValue((Object)class_2433, (String)"atLowerCornerOf(...)");
                Vector3d vector3d = VectorConversionsMCKt.toJOML((class_243)class_2433).mul(0.5);
                Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"mul(...)");
                v3 = myDirNormal = VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)vector3d));
            }
            if (realShip1Pos == null) {
                realShip1Pos = new Vector3d(attachConstraint.getLocalPos0());
                if (context.contraption instanceof StabilizedContraption) {
                    Contraption contraption = context.contraption;
                    Intrinsics.checkNotNull((Object)contraption, (String)"null cannot be cast to non-null type com.simibubi.create.content.contraptions.bearing.StabilizedContraption");
                    class_243 class_2434 = class_243.method_24954((class_2382)((StabilizedContraption)contraption).getFacing().method_10163());
                    Intrinsics.checkNotNullExpressionValue((Object)class_2434, (String)"atLowerCornerOf(...)");
                    realShip1Pos.add((Vector3dc)VectorConversionsMCKt.toJOML((class_243)class_2434).mul(0.125));
                }
                class_243 class_2435 = context.motion;
                Intrinsics.checkNotNullExpressionValue((Object)class_2435, (String)"motion");
                realShip1Pos.add((Vector3dc)VectorConversionsMCKt.toJOML((class_243)class_2435));
                if (distance < 1.05) {
                    Object r = context.rotation.apply(class_243.method_24954((class_2382)myDir.method_10163()));
                    Intrinsics.checkNotNullExpressionValue(r, (String)"apply(...)");
                    realShip1Pos.add((Vector3dc)VectorConversionsMCKt.toJOML((class_243)((class_243)r)).mul(distance / (double)-1 + 1.05));
                }
            }
            if (realShip1Rot == null) {
                realShip1Rot = new Quaterniond(orientationConstraint.getLocalRot0());
                AbstractContraptionEntity.ContraptionRotationState rotationState = context.contraption.entity.getRotationState();
                if (rotationState != null) {
                    realShip1Rot = new Quaterniond().setFromNormalized((Matrix4fc)rotationState.asMatrix().getAsMatrix4f()).mul((Quaterniondc)realShip1Rot);
                }
            }
            Vector3d vector3d = new Vector3d((Vector3dc)realShip1Pos);
            class_1937 class_19372 = context.world;
            Intrinsics.checkNotNull((Object)class_19372, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            Pair constraintPair = SlickerMovementBehavior.Companion.makeConstraint(realShip1Pos, vector3d, ship1, ship2, (class_3218)class_19372, realShip1Rot, ship2Rot, ship2Pos);
            if (constraintPair != null) {
                VSAttachmentConstraint attachConstraint2 = (VSAttachmentConstraint)constraintPair.getFirst();
                VSFixedOrientationConstraint orientationConstraint2 = (VSFixedOrientationConstraint)constraintPair.getSecond();
                class_1937 class_19373 = context.world;
                Intrinsics.checkNotNull((Object)class_19373, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                VSGameUtilsKt.getShipObjectWorld((class_3218)((class_3218)class_19373)).updateConstraint(extraData.method_10550(ClockworkConstants.Nbt.INSTANCE.getATTACHMENT_CONSTRAINT_ID()), (VSConstraint)attachConstraint2);
                class_1937 class_19374 = context.world;
                Intrinsics.checkNotNull((Object)class_19374, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                VSGameUtilsKt.getShipObjectWorld((class_3218)((class_3218)class_19374)).updateConstraint(extraData.method_10550(ClockworkConstants.Nbt.INSTANCE.getORIENTATION_CONSTRAINT_ID()), (VSConstraint)orientationConstraint2);
                extraData.method_10569(ClockworkConstants.Nbt.INSTANCE.getATTACHMENT_CONSTRAINT_ID(), extraData.method_10550(ClockworkConstants.Nbt.INSTANCE.getATTACHMENT_CONSTRAINT_ID()));
                extraData.method_10570(ClockworkConstants.Nbt.INSTANCE.getATTACHMENT_CONSTRAINT(), mapper.writeValueAsBytes((Object)attachConstraint2));
                extraData.method_10569(ClockworkConstants.Nbt.INSTANCE.getORIENTATION_CONSTRAINT_ID(), extraData.method_10550(ClockworkConstants.Nbt.INSTANCE.getORIENTATION_CONSTRAINT_ID()));
                extraData.method_10570(ClockworkConstants.Nbt.INSTANCE.getORIENTATION_CONSTRAINT(), mapper.writeValueAsBytes((Object)orientationConstraint2));
                extraData.method_10549(ClockworkConstants.Nbt.INSTANCE.getSHIP_SLICKER_DISTANCE(), distance);
                ClockworkMod.INSTANCE.getLOGGER().info("Updated constraint from ship " + attachConstraint2.getShipId0() + " to " + attachConstraint2.getShipId1() + " using points " + attachConstraint2.getLocalPos0() + " && " + attachConstraint2.getLocalPos1());
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b-\u0010.JI\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J5\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\n\u00a2\u0006\u0004\b\u0015\u0010\u0016Jg\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 \u0018\u00010\u001e2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0004\b!\u0010\"J%\u0010$\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\n\u00a2\u0006\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0017\u0010)\u001a\u00020(8\u0006\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\u00a8\u0006/"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/phys/slicker/SlickerMovementBehavior$Companion;", "", "Lnet/minecraft/class_3218;", "level", "Lorg/valkyrienskies/core/api/ships/Ship;", "ship1", "ship2", "Lorg/joml/Vector3dc;", "myPos", "myDirNormal", "Lnet/minecraft/class_2487;", "tag", "", "distance", "", "doAttach", "(Lnet/minecraft/class_3218;Lorg/valkyrienskies/core/api/ships/Ship;Lorg/valkyrienskies/core/api/ships/Ship;Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;Lnet/minecraft/class_2487;D)V", "", "attach", "myPosCentered", "compoundTag", "isAttachedToShipOrWorld", "(ZLnet/minecraft/class_3218;Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;Lnet/minecraft/class_2487;)Z", "Lorg/joml/Vector3d;", "ship1ConstraintPos", "ship2ConstraintPos", "Lorg/joml/Quaterniond;", "ship1Rot", "ship2Rot", "ship2Pos", "Lkotlin/Pair;", "Lorg/valkyrienskies/core/apigame/constraints/VSAttachmentConstraint;", "Lorg/valkyrienskies/core/apigame/constraints/VSFixedOrientationConstraint;", "makeConstraint", "(Lorg/joml/Vector3d;Lorg/joml/Vector3d;Lorg/valkyrienskies/core/api/ships/Ship;Lorg/valkyrienskies/core/api/ships/Ship;Lnet/minecraft/class_3218;Lorg/joml/Quaterniond;Lorg/joml/Quaterniond;Lorg/joml/Vector3d;)Lkotlin/Pair;", "removeTags", "removeConstraint", "(Lnet/minecraft/class_3218;ZLnet/minecraft/class_2487;)V", "DISTANCE_BUFFER", "D", "Lcom/fasterxml/jackson/dataformat/cbor/databind/CBORMapper;", "mapper", "Lcom/fasterxml/jackson/dataformat/cbor/databind/CBORMapper;", "getMapper", "()Lcom/fasterxml/jackson/dataformat/cbor/databind/CBORMapper;", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CBORMapper getMapper() {
            return mapper;
        }

        public final boolean isAttachedToShipOrWorld(boolean attach, @NotNull class_3218 level, @NotNull Vector3dc myPosCentered, @NotNull Vector3dc myDirNormal, @NotNull class_2487 compoundTag) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)myPosCentered, (String)"myPosCentered");
            Intrinsics.checkNotNullParameter((Object)myDirNormal, (String)"myDirNormal");
            Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
            boolean result = false;
            ServerShip ship = VSGameUtilsKt.getShipManagingPos((class_3218)level, (Vector3dc)myPosCentered);
            Ship ship2 = null;
            Vector3d vector3d = myDirNormal.mul(0.75, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"mul(...)");
            Vector3d tempDirNormal = vector3d;
            Vector3d vector3d2 = new Vector3d(myPosCentered).add((Vector3dc)tempDirNormal);
            Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"add(...)");
            Vector3d searchPos = vector3d2;
            ServerShip serverShip = ship;
            if (serverShip != null && (serverShip = serverShip.getShipToWorld()) != null) {
                serverShip.transformPosition((Vector3dc)searchPos, searchPos);
            }
            class_2338 class_23382 = class_2338.method_49638((class_2374)((class_2374)VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)searchPos))));
            Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"containing(...)");
            class_2338 searchBlockPos = class_23382;
            class_2680 class_26802 = level.method_8320(searchBlockPos);
            Intrinsics.checkNotNullExpressionValue((Object)class_26802, (String)"getBlockState(...)");
            class_2680 worldBlockState = class_26802;
            double distance = 0.0;
            if (!worldBlockState.method_26215()) {
                distance = Vector3d.distance((double)myPosCentered.x(), (double)myPosCentered.y(), (double)myPosCentered.z(), (double)searchBlockPos.method_10263(), (double)searchBlockPos.method_10264(), (double)searchBlockPos.method_10260());
                result = true;
            } else {
                double bounds = 0.5;
                class_238 searchAABB = new class_238(searchPos.x - bounds, searchPos.y - bounds, searchPos.z - bounds, searchPos.x + bounds, searchPos.y + bounds, searchPos.z + bounds);
                Iterator ships = VSGameUtilsKt.getShipsIntersecting((class_1937)((class_1937)level), (class_238)searchAABB).iterator();
                Ship shipItr = null;
                Vector3d transformedSearchPos = new Vector3d((Vector3dc)searchPos);
                if (ships.hasNext()) {
                    do {
                        class_2680 blockState;
                        class_2338 blockPos;
                        if ((shipItr = (Ship)ships.next()) == ship) continue;
                        shipItr.getWorldToShip().transformPosition(transformedSearchPos);
                        Intrinsics.checkNotNullExpressionValue((Object)class_2338.method_49638((class_2374)((class_2374)VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)transformedSearchPos)))), (String)"containing(...)");
                        if (!VSGameUtilsKt.isBlockInShipyard((class_1937)((class_1937)level), (class_2338)blockPos)) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)level.method_8320(blockPos), (String)"getBlockState(...)");
                        if (blockState.method_26215() || !blockState.method_30368((class_1922)level, blockPos, class_2350.field_11036, class_5431.field_25824)) continue;
                        Vector3d vector3d3 = shipItr.getShipToWorld().transformPosition((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), new Vector3d());
                        Intrinsics.checkNotNullExpressionValue((Object)vector3d3, (String)"transformPosition(...)");
                        class_2338 class_23383 = class_2338.method_49638((class_2374)((class_2374)VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)vector3d3))));
                        Intrinsics.checkNotNullExpressionValue((Object)class_23383, (String)"containing(...)");
                        searchBlockPos = class_23383;
                        distance = Vector3d.distance((double)myPosCentered.x(), (double)myPosCentered.y(), (double)myPosCentered.z(), (double)searchBlockPos.method_10263(), (double)searchBlockPos.method_10264(), (double)searchBlockPos.method_10260());
                        result = true;
                        ship2 = shipItr;
                    } while (ships.hasNext() && !result);
                }
            }
            if (result && !level.field_9236 && attach) {
                this.doAttach(level, (Ship)ship, ship2, myPosCentered, myDirNormal, compoundTag, distance);
            }
            return result;
        }

        public final void doAttach(@NotNull class_3218 level, @Nullable Ship ship1, @Nullable Ship ship2, @NotNull Vector3dc myPos, @NotNull Vector3dc myDirNormal, @NotNull class_2487 tag, double distance) {
            Vector3d attachConstraint;
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)myPos, (String)"myPos");
            Intrinsics.checkNotNullParameter((Object)myDirNormal, (String)"myDirNormal");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            if (ship1 == null && ship2 == null) {
                return;
            }
            this.removeConstraint(level, false, tag);
            Vector3d adjustedDirNormal = new Vector3d(myDirNormal).mul(distance, new Vector3d());
            Vector3d ship1Pos = new Vector3d(myPos).add((Vector3dc)adjustedDirNormal, new Vector3d());
            Vector3d ship2ConstraintPos = new Vector3d((Vector3dc)ship1Pos);
            if (distance < 1.05) {
                ship1Pos.add((Vector3dc)adjustedDirNormal.mul(distance / -1.0 + 1.05, ship1Pos));
            }
            Vector3d ship2Pos = null;
            Quaterniond ship1Rot = null;
            Quaterniond ship2Rot = null;
            double adjustedDistance = distance;
            Ship realShip1 = ship1;
            Ship realShip2 = ship2;
            Vector3d realShip1Pos = ship1Pos;
            Vector3d realShip2Pos = ship2Pos;
            Quaterniond realShip1Rot = ship1Rot;
            Quaterniond realShip2Rot = ship2Rot;
            if (tag.method_10545(ClockworkConstants.Nbt.INSTANCE.getATTACHMENT_CONSTRAINT_ID()) && tag.method_10545(ClockworkConstants.Nbt.INSTANCE.getATTACHMENT_CONSTRAINT()) && tag.method_10545(ClockworkConstants.Nbt.INSTANCE.getORIENTATION_CONSTRAINT_ID()) && tag.method_10545(ClockworkConstants.Nbt.INSTANCE.getORIENTATION_CONSTRAINT())) {
                byte[] attachConstraintData = tag.method_10547(ClockworkConstants.Nbt.INSTANCE.getATTACHMENT_CONSTRAINT());
                attachConstraint = (VSAttachmentConstraint)this.getMapper().readValue(attachConstraintData, VSAttachmentConstraint.class);
                byte[] orientationConstraintData = tag.method_10547(ClockworkConstants.Nbt.INSTANCE.getORIENTATION_CONSTRAINT());
                VSFixedOrientationConstraint orientationConstraint = (VSFixedOrientationConstraint)this.getMapper().readValue(orientationConstraintData, VSFixedOrientationConstraint.class);
                adjustedDistance = attachConstraint.getFixedDistance();
                realShip1 = VSGameUtilsKt.getShipObjectWorld((class_3218)level).getAllShips().getById(attachConstraint.getShipId0());
                realShip2 = VSGameUtilsKt.getShipObjectWorld((class_3218)level).getAllShips().getById(attachConstraint.getShipId1());
                realShip1Pos = new Vector3d(attachConstraint.getLocalPos0());
                realShip2Pos = new Vector3d(attachConstraint.getLocalPos1());
                realShip1Rot = new Quaterniond(orientationConstraint.getLocalRot0());
                realShip2Rot = new Quaterniond(orientationConstraint.getLocalRot1());
            }
            attachConstraint = realShip1Pos;
            Intrinsics.checkNotNull((Object)attachConstraint);
            Pair<VSAttachmentConstraint, VSFixedOrientationConstraint> constraintPair = this.makeConstraint(attachConstraint, ship2ConstraintPos, realShip1, realShip2, level, realShip1Rot, realShip2Rot, realShip2Pos);
            if (constraintPair != null) {
                attachConstraint = (VSAttachmentConstraint)constraintPair.getFirst();
                VSFixedOrientationConstraint orientationConstraint = (VSFixedOrientationConstraint)constraintPair.getSecond();
                Integer attachConstraintId = VSGameUtilsKt.getShipObjectWorld((class_3218)level).createNewConstraint((VSConstraint)attachConstraint);
                Integer orientationConstraintId = VSGameUtilsKt.getShipObjectWorld((class_3218)level).createNewConstraint((VSConstraint)orientationConstraint);
                Integer n = attachConstraintId;
                tag.method_10569(ClockworkConstants.Nbt.INSTANCE.getATTACHMENT_CONSTRAINT_ID(), n != null ? n : -1);
                tag.method_10570(ClockworkConstants.Nbt.INSTANCE.getATTACHMENT_CONSTRAINT(), this.getMapper().writeValueAsBytes((Object)attachConstraint));
                Integer n2 = orientationConstraintId;
                tag.method_10569(ClockworkConstants.Nbt.INSTANCE.getORIENTATION_CONSTRAINT_ID(), n2 != null ? n2 : -1);
                tag.method_10570(ClockworkConstants.Nbt.INSTANCE.getORIENTATION_CONSTRAINT(), this.getMapper().writeValueAsBytes((Object)orientationConstraint));
                tag.method_10549(ClockworkConstants.Nbt.INSTANCE.getSHIP_SLICKER_DISTANCE(), adjustedDistance);
                ClockworkMod.INSTANCE.getLOGGER().info("Attached to ship " + attachConstraint.getShipId1() + " using points " + attachConstraint.getLocalPos0() + " && " + attachConstraint.getLocalPos1());
            }
        }

        private final Pair<VSAttachmentConstraint, VSFixedOrientationConstraint> makeConstraint(Vector3d ship1ConstraintPos, Vector3d ship2ConstraintPos, Ship ship1, Ship ship2, class_3218 level, Quaterniond ship1Rot, Quaterniond ship2Rot, Vector3d ship2Pos) {
            Vector3d realShip2ConstraintPos = ship2ConstraintPos;
            Quaterniond realShip1Rot = ship1Rot;
            Quaterniond realShip2Rot = ship2Rot;
            if (ship1 == null && ship2 == null) {
                return null;
            }
            long ship1Id = 0L;
            long ship2Id = 0L;
            Object v = VSGameUtilsKt.getShipObjectWorld((class_3218)level).getDimensionToGroundBodyIdImmutable().get(VSGameUtilsKt.getDimensionId((class_1937)((class_1937)level)));
            Intrinsics.checkNotNull(v);
            long groundId = ((Number)v).longValue();
            if (ship1Rot == null && ship1 == null) {
                realShip1Rot = new Quaterniond();
            }
            if (ship2Rot == null && ship2 == null) {
                realShip1Rot = new Quaterniond();
            }
            double mass = 100.0;
            if (ship1 != null) {
                ship1.getShipToWorld().transformPosition(realShip2ConstraintPos);
                ship1Id = ship1.getId();
                if (realShip1Rot == null) {
                    Quaterniondc quaterniondc = ship1.getTransform().getShipToWorldRotation();
                    Intrinsics.checkNotNull((Object)quaterniondc, (String)"null cannot be cast to non-null type org.joml.Quaterniond");
                    realShip1Rot = (Quaterniond)quaterniondc;
                }
                Ship ship = VSGameUtilsKt.getShipObjectWorld((class_3218)level).getAllShips().getById(ship1Id);
                Intrinsics.checkNotNull((Object)ship);
                mass = ((ServerShip)ship).getInertiaData().getMass();
            } else {
                ship1Id = groundId;
            }
            if (ship2 != null) {
                ship2.getWorldToShip().transformPosition(realShip2ConstraintPos);
                ship2Id = ship2.getId();
                if (realShip2Rot == null) {
                    Quaterniondc quaterniondc = ship2.getTransform().getShipToWorldRotation();
                    Intrinsics.checkNotNull((Object)quaterniondc, (String)"null cannot be cast to non-null type org.joml.Quaterniond");
                    realShip2Rot = (Quaterniond)quaterniondc;
                }
                Ship ship = VSGameUtilsKt.getShipObjectWorld((class_3218)level).getAllShips().getById(ship2Id);
                Intrinsics.checkNotNull((Object)ship);
                mass = ((ServerShip)ship).getInertiaData().getMass();
            } else {
                ship2Id = groundId;
            }
            if (ship2Pos != null) {
                realShip2ConstraintPos = ship2Pos;
            }
            Quaterniond quaterniond = realShip1Rot;
            Quaterniondc ship1Rotation = quaterniond != null ? (Quaterniondc)quaterniond : (Quaterniondc)new Quaterniond();
            Quaterniond quaterniond2 = realShip2Rot;
            Quaterniondc ship2Rotation = quaterniond2 != null ? (Quaterniondc)quaterniond2 : (Quaterniondc)new Quaterniond();
            VSAttachmentConstraint attachConstraint = new VSAttachmentConstraint(ship1Id, ship2Id, 1.0E-9 / mass, (Vector3dc)ship1ConstraintPos, (Vector3dc)realShip2ConstraintPos, 1.0E10, ship1ConstraintPos.distance((Vector3dc)ship2ConstraintPos));
            VSFixedOrientationConstraint orientationConstraint = new VSFixedOrientationConstraint(ship1Id, ship2Id, 1.0E-9 / mass, ship1Rotation, ship2Rotation, 1.0E10);
            return TuplesKt.to((Object)attachConstraint, (Object)orientationConstraint);
        }

        public final void removeConstraint(@NotNull class_3218 level, boolean removeTags, @NotNull class_2487 compoundTag) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
            if (compoundTag.method_10545(ClockworkConstants.Nbt.INSTANCE.getATTACHMENT_CONSTRAINT_ID())) {
                VSGameUtilsKt.getShipObjectWorld((class_3218)level).removeConstraint(compoundTag.method_10550(ClockworkConstants.Nbt.INSTANCE.getATTACHMENT_CONSTRAINT_ID()));
                if (removeTags) {
                    compoundTag.method_10551(ClockworkConstants.Nbt.INSTANCE.getATTACHMENT_CONSTRAINT_ID());
                    compoundTag.method_10551(ClockworkConstants.Nbt.INSTANCE.getATTACHMENT_CONSTRAINT());
                }
            }
            if (compoundTag.method_10545(ClockworkConstants.Nbt.INSTANCE.getORIENTATION_CONSTRAINT_ID())) {
                VSGameUtilsKt.getShipObjectWorld((class_3218)level).removeConstraint(compoundTag.method_10550(ClockworkConstants.Nbt.INSTANCE.getORIENTATION_CONSTRAINT_ID()));
                if (removeTags) {
                    compoundTag.method_10551(ClockworkConstants.Nbt.INSTANCE.getORIENTATION_CONSTRAINT_ID());
                    compoundTag.method_10551(ClockworkConstants.Nbt.INSTANCE.getORIENTATION_CONSTRAINT());
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

