/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.forces;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.content.propulsion.singleton.fan.EncasedFanCreateData;
import org.valkyrienskies.clockwork.content.propulsion.singleton.fan.EncasedFanData;
import org.valkyrienskies.clockwork.content.propulsion.singleton.fan.EncasedFanUpdateData;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ShipForcesInducer;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 /2\u00020\u0001:\u0001/B\u0007\u00a2\u0006\u0004\b-\u0010.J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001d\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dR&\u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u001f0\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u001d\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00110\"8\u0006\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&R \u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001b0'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0016\u0010*\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00040\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010!\u00a8\u00060"}, d2={"Lorg/valkyrienskies/clockwork/content/forces/EncasedFanController;", "Lorg/valkyrienskies/core/api/ships/ShipForcesInducer;", "Lorg/valkyrienskies/clockwork/content/propulsion/singleton/fan/EncasedFanCreateData;", "data", "", "addEncasedFan", "(Lorg/valkyrienskies/clockwork/content/propulsion/singleton/fan/EncasedFanCreateData;)I", "Lorg/joml/Vector3dc;", "pos", "", "airPressure", "(Lorg/joml/Vector3dc;)D", "Lorg/valkyrienskies/core/api/ships/PhysShip;", "physShip", "", "applyForces", "(Lorg/valkyrienskies/core/api/ships/PhysShip;)V", "Lorg/valkyrienskies/clockwork/content/propulsion/singleton/fan/EncasedFanData;", "physData", "Lorg/valkyrienskies/core/impl/game/ships/PhysShipImpl;", "computeForce", "(Lorg/valkyrienskies/clockwork/content/propulsion/singleton/fan/EncasedFanData;Lorg/valkyrienskies/core/impl/game/ships/PhysShipImpl;)Lorg/joml/Vector3dc;", "exhaustVelocity", "()D", "id", "removeEncasedFan", "(I)V", "Lorg/valkyrienskies/clockwork/content/propulsion/singleton/fan/EncasedFanUpdateData;", "updateEncasedFan", "(ILorg/valkyrienskies/clockwork/content/propulsion/singleton/fan/EncasedFanUpdateData;)V", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lit/unimi/dsi/fastutil/Pair;", "createdFans", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "fanData", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "getFanData", "()Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "Ljava/util/concurrent/ConcurrentHashMap;", "fanUpdateData", "Ljava/util/concurrent/ConcurrentHashMap;", "nextFanID", "I", "removedFans", "<init>", "()V", "Companion", "clockwork"})
public final class EncasedFanController
implements ShipForcesInducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Int2ObjectOpenHashMap<EncasedFanData> fanData = new Int2ObjectOpenHashMap();
    @NotNull
    private final ConcurrentHashMap<Integer, EncasedFanUpdateData> fanUpdateData = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentLinkedQueue<Pair<Integer, EncasedFanCreateData>> createdFans = new ConcurrentLinkedQueue();
    @NotNull
    private final ConcurrentLinkedQueue<Integer> removedFans = new ConcurrentLinkedQueue();
    private int nextFanID;

    @NotNull
    public final Int2ObjectOpenHashMap<EncasedFanData> getFanData() {
        return this.fanData;
    }

    public void applyForces(@NotNull PhysShip physShip) {
        Intrinsics.checkNotNullParameter((Object)physShip, (String)"physShip");
        while (!this.createdFans.isEmpty()) {
            Object e = this.createdFans.remove();
            Intrinsics.checkNotNullExpressionValue(e, (String)"remove(...)");
            Pair createData = (Pair)e;
            Object object = createData.left();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"left(...)");
            this.fanData.put(((Number)object).intValue(), (Object)new EncasedFanData(((EncasedFanCreateData)createData.right()).getFanPos(), ((EncasedFanCreateData)createData.right()).getFanDir(), ((EncasedFanCreateData)createData.right()).getFanSpeed()));
        }
        while (!this.removedFans.isEmpty()) {
            Object e = this.removedFans.remove();
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.Int");
            this.fanData.remove(((Integer)e).intValue());
        }
        this.fanUpdateData.forEach((arg_0, arg_1) -> EncasedFanController.applyForces$lambda$0(this, arg_0, arg_1));
        this.fanUpdateData.clear();
        for (EncasedFanData physData : (ObjectCollection)this.fanData.values()) {
            Intrinsics.checkNotNull((Object)physData);
            Vector3dc force = this.computeForce(physData, (PhysShipImpl)physShip);
            Vector3d vector3d = physData.getFanPos().add(0.5, 0.5, 0.5, new Vector3d()).sub(((PhysShipImpl)physShip).getTransform().getPositionInShip());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"sub(...)");
            Vector3dc fanVector = (Vector3dc)vector3d;
            physShip.applyRotDependentForceToPos(force, fanVector);
        }
    }

    private final Vector3dc computeForce(EncasedFanData physData, PhysShipImpl physShip) {
        double speed = physData.getFanSpeed();
        Vector3d vector3d = new Vector3d(physData.getFanDir()).mul(Math.signum(speed));
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"mul(...)");
        Vector3d dir = vector3d;
        double providedForce = Math.abs(speed) * 36.00875;
        double airPress = this.airPressure(physShip.getTransform().getPositionInWorld());
        Vector3d vector3d2 = physShip.getTransform().getShipToWorld().transformPosition((Vector3dc)physData.getFanPos().add(0.5, 0.5, 0.5, new Vector3d()), new Vector3d()).sub(physShip.getTransform().getPositionInWorld(), new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"sub(...)");
        Vector3dc fanPosRelCenterMass = (Vector3dc)vector3d2;
        Vector3d vector3d3 = physShip.getPoseVel().getOmega().cross(fanPosRelCenterMass, new Vector3d()).add(physShip.getPoseVel().getVel(), new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d3, (String)"add(...)");
        Vector3dc worldVelAtFan = (Vector3dc)vector3d3;
        double exhaustVel = this.exhaustVelocity();
        double factor = 1.0 - class_3532.method_15350((double)(dir.dot(worldVelAtFan) / exhaustVel), (double)0.0, (double)1.0);
        if (!Double.isFinite(factor)) {
            factor = 0.0;
        }
        providedForce = providedForce * airPress * factor;
        Vector3d vector3d4 = dir.mul(providedForce);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d4, (String)"mul(...)");
        return (Vector3dc)vector3d4;
    }

    private final double airPressure(Vector3dc pos) {
        double SEA_LEVEL = 64.0;
        double WORLD_HEIGHT = 320.0;
        double FALLOFF_POINT = 192.0;
        double offset = Math.exp(-(WORLD_HEIGHT - SEA_LEVEL) / FALLOFF_POINT);
        double height = pos.y();
        double airPress = (Math.exp(-(height - SEA_LEVEL) / FALLOFF_POINT) - offset) / (1.0 - offset);
        return Double.isFinite(airPress) ? class_3532.method_15350((double)airPress, (double)0.0, (double)1.0) : 0.0;
    }

    private final double exhaustVelocity() {
        return 44.074;
    }

    public final int addEncasedFan(@NotNull EncasedFanCreateData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int n = this.nextFanID;
        this.nextFanID = n + 1;
        int id = n;
        this.createdFans.add((Pair<Integer, EncasedFanCreateData>)Pair.of((Object)id, (Object)data));
        return id;
    }

    public final void removeEncasedFan(int id) {
        this.removedFans.add(id);
    }

    public final void updateEncasedFan(int id, @NotNull EncasedFanUpdateData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Integer n = id;
        ((Map)this.fanUpdateData).put(n, data);
    }

    private static final void applyForces$lambda$0(EncasedFanController this$0, Integer id, EncasedFanUpdateData data) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        EncasedFanData encasedFanData = (EncasedFanData)this$0.fanData.get((Object)id);
        if (encasedFanData == null) {
            return;
        }
        EncasedFanData physData = encasedFanData;
        physData.setFanSpeed(data.getFanSpeed());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/valkyrienskies/clockwork/content/forces/EncasedFanController$Companion;", "", "Lorg/valkyrienskies/core/api/ships/ServerShip;", "ship", "Lorg/valkyrienskies/clockwork/content/forces/EncasedFanController;", "getOrCreate", "(Lorg/valkyrienskies/core/api/ships/ServerShip;)Lorg/valkyrienskies/clockwork/content/forces/EncasedFanController;", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final EncasedFanController getOrCreate(@NotNull ServerShip ship) {
            Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
            if (ship.getAttachment(EncasedFanController.class) == null) {
                ship.saveAttachment(EncasedFanController.class, (Object)new EncasedFanController());
            }
            return (EncasedFanController)ship.getAttachment(EncasedFanController.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

