/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.forces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4d;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3ic;
import org.valkyrienskies.clockwork.content.contraptions.propeller.data.PropCreateData;
import org.valkyrienskies.clockwork.content.contraptions.propeller.data.PropData;
import org.valkyrienskies.clockwork.content.contraptions.propeller.data.PropUpdateData;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ShipForcesInducer;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;
import org.valkyrienskies.core.impl.game.ships.ShipInertiaDataImpl;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 ;2\u00020\u0001:\u0001;B\u0007\u00a2\u0006\u0004\b9\u0010:J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010JC\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00182\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ/\u0010\u001d\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001a\u0010\"\u001a\u00020!2\b\u0010 \u001a\u0004\u0018\u00010\u001fH\u0096\u0002\u00a2\u0006\u0004\b\"\u0010#J\u001f\u0010%\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b%\u0010&J\u0015\u0010(\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u0004\u00a2\u0006\u0004\b(\u0010)J\u001d\u0010+\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020*\u00a2\u0006\u0004\b+\u0010,R&\u0010.\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u00180-8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0016\u00100\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u00101R \u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0013028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104R \u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020*058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107R\u001a\u00108\u001a\b\u0012\u0004\u0012\u00020\u00040-8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u0010/\u00a8\u0006<"}, d2={"Lorg/valkyrienskies/clockwork/content/forces/PropellerController;", "Lorg/valkyrienskies/core/api/ships/ShipForcesInducer;", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/data/PropCreateData;", "data", "", "addPropeller", "(Lorg/valkyrienskies/clockwork/content/contraptions/propeller/data/PropCreateData;)I", "Lorg/joml/Vector3dc;", "pos", "", "airPressure", "(Lorg/joml/Vector3dc;)D", "Lorg/valkyrienskies/core/api/ships/PhysShip;", "physShip", "", "applyForces", "(Lorg/valkyrienskies/core/api/ships/PhysShip;)V", "Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "physTransform", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/data/PropData;", "physProp", "vel", "omega", "Lorg/valkyrienskies/core/impl/game/ships/PhysShipImpl;", "Lkotlin/Pair;", "computeForce", "(Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;Lorg/valkyrienskies/clockwork/content/contraptions/propeller/data/PropData;Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;Lorg/valkyrienskies/core/impl/game/ships/PhysShipImpl;)Lkotlin/Pair;", "furthestTip", "angVel", "conserveMomentum", "(Lorg/valkyrienskies/core/impl/game/ships/PhysShipImpl;Lorg/valkyrienskies/clockwork/content/contraptions/propeller/data/PropData;Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;)Lorg/joml/Vector3dc;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "posRelBearing", "exhaustVelocity", "(Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;)D", "id", "removePropeller", "(I)V", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/data/PropUpdateData;", "updatePropeller", "(ILorg/valkyrienskies/clockwork/content/contraptions/propeller/data/PropUpdateData;)V", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "createdProps", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "nextPropID", "I", "Ljava/util/HashMap;", "propellorPhysData", "Ljava/util/HashMap;", "Ljava/util/concurrent/ConcurrentHashMap;", "propellorUpdatePhysData", "Ljava/util/concurrent/ConcurrentHashMap;", "removedProps", "<init>", "()V", "Companion", "clockwork"})
@SourceDebugExtension(value={"SMAP\nPropellerController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropellerController.kt\norg/valkyrienskies/clockwork/content/forces/PropellerController\n+ 2 PropellerController.kt\norg/valkyrienskies/clockwork/content/forces/PropellerController$Companion\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,230:1\n226#2:231\n226#2:234\n37#3,2:232\n37#3,2:235\n*S KotlinDebug\n*F\n+ 1 PropellerController.kt\norg/valkyrienskies/clockwork/content/forces/PropellerController\n*L\n210#1:231\n213#1:234\n210#1:232,2\n213#1:235,2\n*E\n"})
public final class PropellerController
implements ShipForcesInducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<Integer, PropData> propellorPhysData = new HashMap();
    @NotNull
    private final ConcurrentHashMap<Integer, PropUpdateData> propellorUpdatePhysData = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentLinkedQueue<Pair<Integer, PropCreateData>> createdProps = new ConcurrentLinkedQueue();
    @NotNull
    private final ConcurrentLinkedQueue<Integer> removedProps = new ConcurrentLinkedQueue();
    private int nextPropID;

    public void applyForces(@NotNull PhysShip physShip) {
        Intrinsics.checkNotNullParameter((Object)physShip, (String)"physShip");
        while (!this.createdProps.isEmpty()) {
            Object e = this.createdProps.remove();
            Intrinsics.checkNotNullExpressionValue(e, (String)"remove(...)");
            Pair createData = (Pair)e;
            ShipInertiaDataImpl propInertiaData = ShipInertiaDataImpl.Companion.newEmptyShipInertiaData();
            for (Vector3ic i : ((PropCreateData)createData.component2()).getPropellorPositions()) {
                propInertiaData.onSetBlock(i.x(), i.y(), i.z(), 0.0, 100.0);
            }
            ((Map)this.propellorPhysData).put(createData.component1(), new PropData(((PropCreateData)createData.component2()).getBearingPos(), ((PropCreateData)createData.component2()).getBearingAxis(), ((PropCreateData)createData.component2()).getBearingAngle(), ((PropCreateData)createData.component2()).getBearingSpeed(), ((PropCreateData)createData.component2()).getPropellorPositions(), ((PropCreateData)createData.component2()).getInverted(), ((PropCreateData)createData.component2()).getOverStressed()));
        }
        while (!this.removedProps.isEmpty()) {
            Object e = this.removedProps.remove();
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.Int");
            this.propellorPhysData.remove((Integer)e);
        }
        this.propellorUpdatePhysData.forEach((arg_0, arg_1) -> PropellerController.applyForces$lambda$0(this, arg_0, arg_1));
        this.propellorUpdatePhysData.clear();
        Vector3d netForce = new Vector3d();
        Vector3d netTorque = new Vector3d();
        for (PropData physData : this.propellorPhysData.values()) {
            if (physData.getOverStressed()) continue;
            ShipTransform shipTransform = physShip.getTransform();
            Intrinsics.checkNotNull((Object)physData);
            Pair<Vector3dc, Vector3dc> forceTorque = this.computeForce(shipTransform, physData, ((PhysShipImpl)physShip).getPoseVel().getVel(), ((PhysShipImpl)physShip).getPoseVel().getOmega(), (PhysShipImpl)physShip);
            netForce.add((Vector3dc)forceTorque.component1());
            netTorque.add((Vector3dc)forceTorque.component2());
        }
        if (netForce.isFinite() && netTorque.isFinite()) {
            physShip.applyInvariantForce((Vector3dc)netForce);
            physShip.applyInvariantTorque((Vector3dc)netTorque);
        }
    }

    private final Pair<Vector3dc, Vector3dc> computeForce(ShipTransform physTransform, PropData physProp, Vector3dc vel, Vector3dc omega, PhysShipImpl physShip) {
        double modifiedSpeed = physProp.getBearingSpeed() * 1.5;
        Vector3d vector3d = new Vector3d(physProp.getBearingPos()).add(0.5, 0.5, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"add(...)");
        Vector3dc bearingVector = (Vector3dc)vector3d;
        Vector3dc vector3dc = physProp.getBearingAxis();
        Intrinsics.checkNotNull((Object)vector3dc);
        Vector3d vector3d2 = vector3dc.mul(Math.signum(modifiedSpeed), new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"mul(...)");
        Vector3dc axis = (Vector3dc)vector3d2;
        Quaterniondc rotation = (Quaterniondc)new Quaterniond(new AxisAngle4d(Math.toRadians(physProp.getBearingAngle()), axis));
        Vector3d vector3d3 = axis.mul(modifiedSpeed / 60.0 * (Math.PI * 2), new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d3, (String)"mul(...)");
        Vector3dc angVel = (Vector3dc)vector3d3;
        Vector3d furthestTip = new Vector3d();
        Vector3d netForce = new Vector3d();
        Vector3d netTorque = new Vector3d();
        List<Vector3ic> list = physProp.getPropellorPositions();
        Intrinsics.checkNotNull(list);
        for (Vector3ic pos : list) {
            Vector3d vector3d4 = new Vector3d((double)pos.x(), (double)pos.y(), (double)pos.z()).add(bearingVector);
            Intrinsics.checkNotNullExpressionValue((Object)vector3d4, (String)"add(...)");
            Vector3dc sailVector = (Vector3dc)vector3d4;
            Vector3d vector3d5 = sailVector.sub(bearingVector, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d5, (String)"sub(...)");
            Vector3dc diff = (Vector3dc)vector3d5;
            Vector3d vector3d6 = rotation.transform(diff, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d6, (String)"transform(...)");
            Vector3dc rotatedDiff = (Vector3dc)vector3d6;
            Vector3d vector3d7 = rotatedDiff.cross(angVel, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d7, (String)"cross(...)");
            Vector3dc sailVel = (Vector3dc)vector3d7;
            if (rotatedDiff.length() > furthestTip.length()) {
                furthestTip.set(rotatedDiff);
            }
            Vector3d force = physTransform.getShipToWorldRotation().transform(axis.mul(sailVel.length(), new Vector3d())).mul(5000.0, new Vector3d());
            Vector3d vector3d8 = physTransform.getShipToWorld().transformPosition(sailVector, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d8, (String)"transformPosition(...)");
            Vector3dc sailPosWorld = (Vector3dc)vector3d8;
            Vector3d vector3d9 = sailPosWorld.sub(physTransform.getPositionInWorld(), new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d9, (String)"sub(...)");
            Vector3dc sailPosRelShip = (Vector3dc)vector3d9;
            Vector3d torque = sailPosRelShip.cross((Vector3dc)force, new Vector3d());
            Vector3d vector3d10 = physTransform.getShipToWorld().transformPosition(sailVector, new Vector3d()).sub(physTransform.getPositionInWorld(), new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d10, (String)"sub(...)");
            Vector3dc sailPosRelCenterMass = (Vector3dc)vector3d10;
            Vector3d vector3d11 = omega.cross(sailPosRelCenterMass, new Vector3d()).add(vel, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d11, (String)"add(...)");
            Vector3dc worldVelAtSail = (Vector3dc)vector3d11;
            double exhaustVel = this.exhaustVelocity(rotatedDiff, angVel);
            double factor = 1.0 - class_3532.method_15350((double)(axis.dot(worldVelAtSail) / exhaustVel), (double)0.0, (double)1.0);
            if (!Double.isFinite(factor)) {
                factor = 1.0;
            }
            double airPress = this.airPressure(sailPosWorld);
            force.mul(airPress * factor);
            torque.mul(airPress * factor);
            netForce.add((Vector3dc)force);
            netTorque.add((Vector3dc)torque);
        }
        if (physProp.getInverted()) {
            netForce.mul(-1.0);
        }
        return new Pair((Object)netForce, (Object)netTorque);
    }

    private final Vector3dc conserveMomentum(PhysShipImpl physShip, PropData physProp, Vector3dc furthestTip, Vector3dc angVel) {
        Vector3dc prevAngMomentumRelProp = (Vector3dc)new Vector3d();
        if (physProp.getPrevAngularMomentum() != null) {
            Vector3dc vector3dc = physProp.getPrevAngularMomentum();
            Intrinsics.checkNotNull((Object)vector3dc);
            prevAngMomentumRelProp = vector3dc;
        }
        Vector3dc propAxis = (Vector3dc)new Vector3d(physProp.getBearingAxis());
        double propSpeed = physProp.getBearingSpeed();
        double rotVel = propSpeed * 0.10471975511965977 * (double)-1;
        Vector3d vector3d = new Vector3d(propAxis).mul(rotVel);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"mul(...)");
        Vector3dc angularVelocityPropeller = (Vector3dc)vector3d;
        Vector3d vector3d2 = angularVelocityPropeller.mul(physShip.getInertia().getMomentOfInertiaTensor(), new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"mul(...)");
        Vector3dc angularMomentumRelProp = (Vector3dc)vector3d2;
        Vector3dc centerOfMassInShip = physShip.getTransform().getPositionInShip();
        Vector3d vector3d3 = new Vector3d((Vector3dc)centerOfMassInShip.add(physProp.getBearingPos(), new Vector3d())).sub(physShip.getTransform().getPositionInShip()).rotate(physShip.getTransform().getShipToWorldRotation());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d3, (String)"rotate(...)");
        Vector3dc r = (Vector3dc)vector3d3;
        Vector3d vector3d4 = new Vector3d(physShip.getPoseVel().getOmega()).cross(r).mul(physShip.getInertia().getShipMass());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d4, (String)"mul(...)");
        Vector3dc momentumModifier = (Vector3dc)vector3d4;
        Vector3d vector3d5 = new Vector3d(angularMomentumRelProp).add(momentumModifier);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d5, (String)"add(...)");
        Vector3dc angularMomentumRelShip = (Vector3dc)vector3d5;
        Vector3d vector3d6 = new Vector3d(prevAngMomentumRelProp).add(momentumModifier);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d6, (String)"add(...)");
        Vector3dc prevAngularMomentumRelShip = (Vector3dc)vector3d6;
        Vector3d vector3d7 = new Vector3d(prevAngularMomentumRelShip).sub(angularMomentumRelShip).div(0.016666666666666666);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d7, (String)"div(...)");
        Vector3dc torque = (Vector3dc)vector3d7;
        physProp.setPrevAngularMomentum(angularMomentumRelProp);
        return torque;
    }

    private final double airPressure(Vector3dc pos) {
        double offset = Math.exp(-1.3333333333333333);
        double height = pos.y();
        double airPress = (Math.exp(-(height - 64.0) / (double)192) - offset) / (1.0 - offset);
        return Double.isFinite(airPress) ? class_3532.method_15350((double)airPress, (double)0.0, (double)1.0) : 0.0;
    }

    private final double exhaustVelocity(Vector3dc posRelBearing, Vector3dc omega) {
        return Math.min(posRelBearing.cross(omega, new Vector3d()).length() * (double)15, 40.0);
    }

    public final int addPropeller(@NotNull PropCreateData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int n = this.nextPropID;
        this.nextPropID = n + 1;
        int id = n;
        this.createdProps.add((Pair<Integer, PropCreateData>)new Pair((Object)id, (Object)data));
        return id;
    }

    public final void removePropeller(int id) {
        this.removedProps.add(id);
    }

    public final void updatePropeller(int id, @NotNull PropUpdateData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Integer n = id;
        ((Map)this.propellorUpdatePhysData).put(n, data);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        Queue right$iv;
        Queue left$iv;
        if (this == other) {
            return true;
        }
        if (!(other instanceof PropellerController)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.propellorPhysData, ((PropellerController)other).propellorPhysData)) return false;
        if (!Intrinsics.areEqual(this.propellorUpdatePhysData, ((PropellerController)other).propellorUpdatePhysData)) return false;
        Companion companion = Companion;
        Queue queue = this.createdProps;
        Queue queue2 = ((PropellerController)other).createdProps;
        boolean $i$f$areQueuesEqual = false;
        Object $this$toTypedArray$iv$iv = (Object[])left$iv;
        boolean $i$f$toTypedArray = false;
        Object[] thisCollection$iv$iv = $this$toTypedArray$iv$iv;
        $this$toTypedArray$iv$iv = thisCollection$iv$iv.toArray(new Pair[0]);
        Object[] $this$toTypedArray$iv$iv2 = (Object[])right$iv;
        boolean $i$f$toTypedArray2 = false;
        Object thisCollection$iv$iv2 = $this$toTypedArray$iv$iv2;
        $this$toTypedArray$iv$iv2 = thisCollection$iv$iv2.toArray(new Pair[0]);
        if (!Arrays.equals((Object[])$this$toTypedArray$iv$iv, $this$toTypedArray$iv$iv2)) return false;
        Companion this_$iv = Companion;
        left$iv = this.removedProps;
        right$iv = ((PropellerController)other).removedProps;
        $i$f$areQueuesEqual = false;
        $this$toTypedArray$iv$iv = left$iv;
        $i$f$toTypedArray = false;
        Object thisCollection$iv$iv22 = $this$toTypedArray$iv$iv;
        Object[] objectArray = thisCollection$iv$iv22.toArray(new Integer[0]);
        Collection $this$toTypedArray$iv$iv22 = right$iv;
        $i$f$toTypedArray = false;
        thisCollection$iv$iv2 = $this$toTypedArray$iv$iv22;
        Object[] objectArray2 = thisCollection$iv$iv2.toArray(new Integer[0]);
        if (!Arrays.equals(objectArray, objectArray2)) return false;
        if (this.nextPropID != ((PropellerController)other).nextPropID) return false;
        return true;
    }

    private static final void applyForces$lambda$0(PropellerController this$0, int id, PropUpdateData data) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        PropData propData = this$0.propellorPhysData.get(id);
        if (propData == null) {
            return;
        }
        PropData physData = propData;
        physData.setBearingAngle(data.getRotationAngle());
        physData.setBearingSpeed(data.getRotationSpeed());
        physData.setInverted(data.getInverted());
        physData.setOverStressed(data.getOverStressed());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ4\u0010\u0007\u001a\u00020\u0006\"\u0006\b\u0000\u0010\u0002\u0018\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0086\b\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/valkyrienskies/clockwork/content/forces/PropellerController$Companion;", "", "T", "Ljava/util/Queue;", "left", "right", "", "areQueuesEqual", "(Ljava/util/Queue;Ljava/util/Queue;)Z", "Lorg/valkyrienskies/core/api/ships/ServerShip;", "ship", "Lorg/valkyrienskies/clockwork/content/forces/PropellerController;", "getOrCreate", "(Lorg/valkyrienskies/core/api/ships/ServerShip;)Lorg/valkyrienskies/clockwork/content/forces/PropellerController;", "<init>", "()V", "clockwork"})
    @SourceDebugExtension(value={"SMAP\nPropellerController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropellerController.kt\norg/valkyrienskies/clockwork/content/forces/PropellerController$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,230:1\n37#2,2:231\n*S KotlinDebug\n*F\n+ 1 PropellerController.kt\norg/valkyrienskies/clockwork/content/forces/PropellerController$Companion\n*L\n226#1:231,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PropellerController getOrCreate(@NotNull ServerShip ship) {
            Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
            if (ship.getAttachment(PropellerController.class) == null) {
                ship.saveAttachment(PropellerController.class, (Object)new PropellerController());
            }
            return (PropellerController)ship.getAttachment(PropellerController.class);
        }

        public final /* synthetic */ <T> boolean areQueuesEqual(Queue<T> left, Queue<T> right) {
            Intrinsics.checkNotNullParameter(left, (String)"left");
            Intrinsics.checkNotNullParameter(right, (String)"right");
            boolean $i$f$areQueuesEqual = false;
            Collection $this$toTypedArray$iv = left;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Intrinsics.reifiedOperationMarker((int)0, (String)"T?");
            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
            Collection $this$toTypedArray$iv2 = right;
            boolean $i$f$toTypedArray2 = false;
            Collection thisCollection$iv2 = $this$toTypedArray$iv2;
            Intrinsics.reifiedOperationMarker((int)0, (String)"T?");
            Object[] objectArray2 = thisCollection$iv2.toArray(new Object[0]);
            return Arrays.equals(objectArray, objectArray2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

