/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.forces.contraption;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3dc;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.content.contraptions.phys.bearing.data.PhysBearingCreateData;
import org.valkyrienskies.clockwork.content.contraptions.phys.bearing.data.PhysBearingData;
import org.valkyrienskies.clockwork.content.contraptions.phys.bearing.data.PhysBearingUpdateData;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ShipForcesInducer;
import org.valkyrienskies.core.apigame.constraints.VSAttachmentConstraint;
import org.valkyrienskies.core.apigame.constraints.VSHingeOrientationConstraint;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 K2\u00020\u0001:\u0001KB\u0007\u00a2\u0006\u0004\bI\u0010JJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ1\u0010\u0010\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u00072\u0018\u0010\u000f\u001a\u0014\u0012\b\u0012\u00060\rj\u0002`\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00070\fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J)\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0003\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ)\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0003\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001aJ)\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0003\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001aJ\u001a\u0010\u001f\u001a\u00020\u00122\b\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0096\u0002\u00a2\u0006\u0004\b\u001f\u0010 J7\u0010)\u001a\u00020%2\u0006\u0010\"\u001a\u00020!2\u0006\u0010$\u001a\u00020#2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b)\u0010*J'\u0010)\u001a\u00020%2\u0006\u0010\b\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b)\u0010,J\u001f\u0010/\u001a\u00020%2\u0006\u0010-\u001a\u00020%2\u0006\u0010.\u001a\u00020%H\u0002\u00a2\u0006\u0004\b/\u00100J\u0015\u00102\u001a\u00020\t2\u0006\u00101\u001a\u00020\u0004\u00a2\u0006\u0004\b2\u00103J\u001d\u00105\u001a\u00020\t2\u0006\u00104\u001a\u00020\u00122\u0006\u00101\u001a\u00020\u0004\u00a2\u0006\u0004\b5\u00106J\u001d\u00108\u001a\u00020\t2\u0006\u00101\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u000207\u00a2\u0006\u0004\b8\u00109R#\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150:8\u0006\u00a2\u0006\f\n\u0004\b;\u0010<\u001a\u0004\b=\u0010>R \u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002070?8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b@\u0010AR&\u0010D\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020C0B8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\bD\u0010ER\u0016\u0010F\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bF\u0010GR\u001a\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00040B8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bH\u0010E\u00a8\u0006L"}, d2={"Lorg/valkyrienskies/clockwork/content/forces/contraption/BearingController;", "Lorg/valkyrienskies/core/api/ships/ShipForcesInducer;", "Lorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/data/PhysBearingCreateData;", "data", "", "addPhysBearing", "(Lorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/data/PhysBearingCreateData;)I", "Lorg/valkyrienskies/core/api/ships/PhysShip;", "physShip", "", "applyForces", "(Lorg/valkyrienskies/core/api/ships/PhysShip;)V", "Lkotlin/Function1;", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "lookupPhysShip", "applyForcesAndLookupPhysShips", "(Lorg/valkyrienskies/core/api/ships/PhysShip;Lkotlin/jvm/functions/Function1;)V", "", "canDisassemble", "()Z", "Lorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/data/PhysBearingData;", "Lorg/valkyrienskies/core/impl/game/ships/PhysShipImpl;", "otherPhysShip", "Lorg/joml/Vector3dc;", "computeLockedRotationalForce", "(Lorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/data/PhysBearingData;Lorg/valkyrienskies/core/impl/game/ships/PhysShipImpl;Lorg/valkyrienskies/core/impl/game/ships/PhysShipImpl;)Lorg/joml/Vector3dc;", "computeRotationalForce", "computeUnlockedRotationalForce", "", "other", "equals", "(Ljava/lang/Object;)Z", "Lorg/joml/Matrix3dc;", "inertiaTensorLocal", "Lorg/joml/Quaterniondc;", "rotation", "", "mass", "offsetGlobal", "axisGlobal", "getAngularInertia", "(Lorg/joml/Matrix3dc;Lorg/joml/Quaterniondc;DLorg/joml/Vector3dc;Lorg/joml/Vector3dc;)D", "localPos", "(Lorg/valkyrienskies/core/impl/game/ships/PhysShipImpl;Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;)D", "left", "right", "parallelOperator", "(DD)D", "id", "removePhysBearing", "(I)V", "yn", "setAligning", "(ZI)V", "Lorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/data/PhysBearingUpdateData;", "updatePhysBearing", "(ILorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/data/PhysBearingUpdateData;)V", "Ljava/util/HashMap;", "bearingData", "Ljava/util/HashMap;", "getBearingData", "()Ljava/util/HashMap;", "Ljava/util/concurrent/ConcurrentHashMap;", "bearingUpdateData", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lkotlin/Pair;", "createdBearings", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "nextBearingID", "I", "removedBearings", "<init>", "()V", "Companion", "clockwork"})
@SourceDebugExtension(value={"SMAP\nBearingController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BearingController.kt\norg/valkyrienskies/clockwork/content/forces/contraption/BearingController\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 BearingController.kt\norg/valkyrienskies/clockwork/content/forces/contraption/BearingController$Companion\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,344:1\n215#2,2:345\n340#3:347\n340#3:350\n37#4,2:348\n37#4,2:351\n*S KotlinDebug\n*F\n+ 1 BearingController.kt\norg/valkyrienskies/clockwork/content/forces/contraption/BearingController\n*L\n59#1:345,2\n316#1:347\n319#1:350\n316#1:348,2\n319#1:351,2\n*E\n"})
public final class BearingController
implements ShipForcesInducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<Integer, PhysBearingData> bearingData = new HashMap();
    @JsonIgnore
    @NotNull
    private final ConcurrentHashMap<Integer, PhysBearingUpdateData> bearingUpdateData = new ConcurrentHashMap();
    @JsonIgnore
    @NotNull
    private final ConcurrentLinkedQueue<Pair<Integer, PhysBearingCreateData>> createdBearings = new ConcurrentLinkedQueue();
    @NotNull
    private final ConcurrentLinkedQueue<Integer> removedBearings = new ConcurrentLinkedQueue();
    private int nextBearingID;

    @NotNull
    public final HashMap<Integer, PhysBearingData> getBearingData() {
        return this.bearingData;
    }

    public void applyForces(@NotNull PhysShip physShip) {
        Intrinsics.checkNotNullParameter((Object)physShip, (String)"physShip");
    }

    public void applyForcesAndLookupPhysShips(@NotNull PhysShip physShip, @NotNull Function1<? super Long, ? extends PhysShip> lookupPhysShip) {
        Intrinsics.checkNotNullParameter((Object)physShip, (String)"physShip");
        Intrinsics.checkNotNullParameter(lookupPhysShip, (String)"lookupPhysShip");
        while (!this.createdBearings.isEmpty()) {
            Pair createData = (Pair)this.createdBearings.remove();
            ((Map)this.bearingData).put(createData.component1(), new PhysBearingData(((PhysBearingCreateData)createData.component2()).getBearingPos(), ((PhysBearingCreateData)createData.component2()).getBearingAxis(), ((PhysBearingCreateData)createData.component2()).getBearingAngle(), ((PhysBearingCreateData)createData.component2()).getBearingRPM(), ((PhysBearingCreateData)createData.component2()).getLocked(), ((PhysBearingCreateData)createData.component2()).getShiptraptionID(), ((PhysBearingCreateData)createData.component2()).getConstraint(), ((PhysBearingCreateData)createData.component2()).getHingeConstraint(), ((PhysBearingCreateData)createData.component2()).getPosDampConstraint(), ((PhysBearingCreateData)createData.component2()).getRotDampConstraint(), ((PhysBearingCreateData)createData.component2()).getSecondAttachment()));
        }
        while (!this.removedBearings.isEmpty()) {
            Object e = this.removedBearings.remove();
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.Int");
            this.bearingData.remove((Integer)e);
        }
        Map $this$forEach$iv = this.bearingUpdateData;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            PhysBearingData physBearingData;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            int id = ((Number)entry.getKey()).intValue();
            PhysBearingUpdateData data = (PhysBearingUpdateData)entry.getValue();
            if (this.bearingData.get(id) == null) continue;
            Intrinsics.checkNotNull((Object)physBearingData);
            PhysBearingData physData = physBearingData;
            physData.setBearingAngle(data.getBearingAngle());
            physData.setBearingRPM(data.getBearingRPM());
            physData.setLocked(data.getLocked());
        }
        this.bearingUpdateData.clear();
        for (PhysBearingData data : this.bearingData.values()) {
            Vector3dc torque;
            if (data.getAngleConstraint() != null) continue;
            VSHingeOrientationConstraint vSHingeOrientationConstraint = data.getHingeConstraint();
            Intrinsics.checkNotNull((Object)vSHingeOrientationConstraint);
            long physShipBearingIsOnId = vSHingeOrientationConstraint.getShipId1();
            if (physShipBearingIsOnId == -1L) {
                Intrinsics.checkNotNull((Object)data);
                Vector3dc torque2 = this.computeRotationalForce(data, (PhysShipImpl)physShip, null);
                physShip.applyInvariantTorque(torque2);
                continue;
            }
            PhysShip physShipBearingIsOn = (PhysShip)lookupPhysShip.invoke((Object)physShipBearingIsOnId);
            if (physShipBearingIsOn == null) {
                Intrinsics.checkNotNull((Object)data);
                torque = this.computeRotationalForce(data, (PhysShipImpl)physShip, null);
                physShip.applyInvariantTorque(torque);
                continue;
            }
            Intrinsics.checkNotNull((Object)data);
            torque = this.computeRotationalForce(data, (PhysShipImpl)physShip, (PhysShipImpl)physShipBearingIsOn);
            physShip.applyInvariantTorque(torque);
            PhysShipImpl physShipImpl = (PhysShipImpl)physShipBearingIsOn;
            Vector3d vector3d = torque.mul(-1.0, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"mul(...)");
            physShipImpl.applyInvariantTorque((Vector3dc)vector3d);
        }
    }

    private final Vector3dc computeRotationalForce(PhysBearingData data, PhysShipImpl physShip, PhysShipImpl otherPhysShip) {
        Vector3dc torque = null;
        torque = data.getLocked() ? this.computeLockedRotationalForce(data, physShip, otherPhysShip) : this.computeUnlockedRotationalForce(data, physShip, otherPhysShip);
        return torque;
    }

    private final double getAngularInertia(PhysShipImpl physShip, Vector3dc localPos, Vector3dc axisGlobal) {
        Vector3d vector3d = physShip.getTransform().getShipToWorld().transformPosition(localPos, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"transformPosition(...)");
        Vector3dc globalPos = (Vector3dc)vector3d;
        Vector3d vector3d2 = globalPos.sub(physShip.getPoseVel().getPos(), new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"sub(...)");
        Vector3dc offset = (Vector3dc)vector3d2;
        return this.getAngularInertia(physShip.getInertia().getMomentOfInertiaTensor(), physShip.getTransform().getShipToWorldRotation(), physShip.getInertia().getShipMass(), offset, axisGlobal);
    }

    private final double getAngularInertia(Matrix3dc inertiaTensorLocal, Quaterniondc rotation, double mass, Vector3dc offsetGlobal, Vector3dc axisGlobal) {
        Vector3d vector3d = offsetGlobal.sub((Vector3dc)axisGlobal.mul(axisGlobal.dot(offsetGlobal), new Vector3d()), new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"sub(...)");
        Vector3dc offsetPerpToAxis = (Vector3dc)vector3d;
        Vector3d vector3d2 = rotation.transformInverse(axisGlobal, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"transformInverse(...)");
        Vector3dc axisLocal = (Vector3dc)vector3d2;
        return inertiaTensorLocal.transform(axisLocal, new Vector3d()).dot(axisLocal) + offsetPerpToAxis.lengthSquared() * mass;
    }

    private final double parallelOperator(double left, double right) {
        return 1.0 / (1.0 / left + 1.0 / right);
    }

    private final Vector3dc computeUnlockedRotationalForce(PhysBearingData data, PhysShipImpl physShip, PhysShipImpl otherPhysShip) {
        if (data.getBearingAxis() == null) {
            return (Vector3dc)new Vector3d();
        }
        Vector3d bearingAxisInGlobal = new Vector3d(data.getBearingAxis());
        PhysShipImpl physShipImpl = otherPhysShip;
        if (physShipImpl != null && (physShipImpl = physShipImpl.getTransform()) != null && (physShipImpl = physShipImpl.getShipToWorldRotation()) != null) {
            physShipImpl.transform(bearingAxisInGlobal);
        }
        Vector3d idealRelativeOmega = bearingAxisInGlobal.mul((double)data.getBearingRPM(), new Vector3d()).mul(0.10471975511965977);
        Vector3d actualRelativeOmega = null;
        actualRelativeOmega = !physShip.isStatic() ? new Vector3d(physShip.getPoseVel().getOmega()) : new Vector3d();
        double torqueMassMultiplier = 0.0;
        if (!physShip.isStatic()) {
            if (otherPhysShip != null && !otherPhysShip.isStatic()) {
                VSAttachmentConstraint vSAttachmentConstraint = data.getAttachConstraint();
                Intrinsics.checkNotNull((Object)vSAttachmentConstraint);
                double physShipInertia = this.getAngularInertia(physShip, vSAttachmentConstraint.getLocalPos0(), (Vector3dc)bearingAxisInGlobal);
                VSAttachmentConstraint vSAttachmentConstraint2 = data.getAttachConstraint();
                Intrinsics.checkNotNull((Object)vSAttachmentConstraint2);
                double otherShipInertia = this.getAngularInertia(otherPhysShip, vSAttachmentConstraint2.getLocalPos1(), (Vector3dc)bearingAxisInGlobal);
                torqueMassMultiplier = this.parallelOperator(physShipInertia, otherShipInertia);
                actualRelativeOmega.sub(otherPhysShip.getPoseVel().getOmega());
            } else {
                VSAttachmentConstraint vSAttachmentConstraint = data.getAttachConstraint();
                Intrinsics.checkNotNull((Object)vSAttachmentConstraint);
                torqueMassMultiplier = this.getAngularInertia(physShip, vSAttachmentConstraint.getLocalPos0(), (Vector3dc)bearingAxisInGlobal);
            }
        } else if (otherPhysShip != null && !otherPhysShip.isStatic()) {
            VSAttachmentConstraint vSAttachmentConstraint = data.getAttachConstraint();
            Intrinsics.checkNotNull((Object)vSAttachmentConstraint);
            torqueMassMultiplier = this.getAngularInertia(otherPhysShip, vSAttachmentConstraint.getLocalPos1(), (Vector3dc)bearingAxisInGlobal);
            actualRelativeOmega.sub(otherPhysShip.getPoseVel().getOmega());
        } else {
            return (Vector3dc)new Vector3d();
        }
        Vector3d vector3d = data.getBearingAxis().rotate(physShip.getPoseVel().getRot(), new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"rotate(...)");
        Vector3dc bearingAxisAfterRot = (Vector3dc)vector3d;
        if (otherPhysShip != null) {
            Vector3d vector3d2 = otherPhysShip.getPoseVel().getRot().transformInverse(bearingAxisAfterRot, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"transformInverse(...)");
            bearingAxisAfterRot = (Vector3dc)vector3d2;
        }
        if (bearingAxisAfterRot.angleCos(data.getBearingAxis()) < 0.9961947 && bearingAxisAfterRot.angleCos(data.getBearingAxis()) > -0.9961947) {
            return (Vector3dc)new Vector3d();
        }
        Vector3d vector3d3 = idealRelativeOmega.sub((Vector3dc)actualRelativeOmega, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d3, (String)"sub(...)");
        Vector3dc angularVelError = (Vector3dc)vector3d3;
        Vector3d vector3d4 = bearingAxisInGlobal.mul(bearingAxisInGlobal.dot(angularVelError), new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d4, (String)"mul(...)");
        Vector3dc angularVelErrorAlongBearingAxis = (Vector3dc)vector3d4;
        Vector3d vector3d5 = angularVelErrorAlongBearingAxis.mul(torqueMassMultiplier * 10.0, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d5, (String)"mul(...)");
        return (Vector3dc)vector3d5;
    }

    private final Vector3dc computeLockedRotationalForce(PhysBearingData data, PhysShipImpl physShip, PhysShipImpl otherPhysShip) {
        double angleErr;
        Vector3dc vector3dc;
        if (data.getBearingAxis() == null) {
            return (Vector3dc)new Vector3d();
        }
        Vector3d bearingAxisInGlobal = new Vector3d(data.getBearingAxis());
        PhysShipImpl physShipImpl = otherPhysShip;
        if (physShipImpl != null && (physShipImpl = physShipImpl.getTransform()) != null && (physShipImpl = physShipImpl.getShipToWorldRotation()) != null) {
            physShipImpl.transform(bearingAxisInGlobal);
        }
        Vector3d actualRelativeOmega = null;
        actualRelativeOmega = !physShip.isStatic() ? new Vector3d(physShip.getPoseVel().getOmega()) : new Vector3d();
        double torqueMassMultiplier = 0.0;
        if (!physShip.isStatic()) {
            if (otherPhysShip != null && !otherPhysShip.isStatic()) {
                VSAttachmentConstraint vSAttachmentConstraint = data.getAttachConstraint();
                Intrinsics.checkNotNull((Object)vSAttachmentConstraint);
                double physShipInertia = this.getAngularInertia(physShip, vSAttachmentConstraint.getLocalPos0(), (Vector3dc)bearingAxisInGlobal);
                VSAttachmentConstraint vSAttachmentConstraint2 = data.getAttachConstraint();
                Intrinsics.checkNotNull((Object)vSAttachmentConstraint2);
                double otherShipInertia = this.getAngularInertia(otherPhysShip, vSAttachmentConstraint2.getLocalPos1(), (Vector3dc)bearingAxisInGlobal);
                torqueMassMultiplier = this.parallelOperator(physShipInertia, otherShipInertia);
                actualRelativeOmega.sub(otherPhysShip.getPoseVel().getOmega());
            } else {
                VSAttachmentConstraint vSAttachmentConstraint = data.getAttachConstraint();
                Intrinsics.checkNotNull((Object)vSAttachmentConstraint);
                torqueMassMultiplier = this.getAngularInertia(physShip, vSAttachmentConstraint.getLocalPos0(), (Vector3dc)bearingAxisInGlobal);
            }
        } else if (otherPhysShip != null && !otherPhysShip.isStatic()) {
            VSAttachmentConstraint vSAttachmentConstraint = data.getAttachConstraint();
            Intrinsics.checkNotNull((Object)vSAttachmentConstraint);
            torqueMassMultiplier = this.getAngularInertia(otherPhysShip, vSAttachmentConstraint.getLocalPos1(), (Vector3dc)bearingAxisInGlobal);
            actualRelativeOmega.sub(otherPhysShip.getPoseVel().getOmega());
        } else {
            return (Vector3dc)new Vector3d();
        }
        if (Math.abs(data.getBearingAxis().x()) == 1.0) {
            vector3dc = (Vector3dc)new Vector3d(0.0, 1.0, 0.0);
        } else if (Math.abs(data.getBearingAxis().y()) == 1.0) {
            vector3dc = (Vector3dc)new Vector3d(1.0, 0.0, 0.0);
        } else if (Math.abs(data.getBearingAxis().z()) == 1.0) {
            vector3dc = (Vector3dc)new Vector3d(0.0, 1.0, 0.0);
        } else {
            throw new RuntimeException("how the fuck did you mess this up g");
        }
        Vector3dc perpendicularAxis = vector3dc;
        Vector3d vector3d = data.getBearingAxis().rotate(physShip.getPoseVel().getRot(), new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"rotate(...)");
        Vector3dc bearingAxisAfterRot = (Vector3dc)vector3d;
        Vector3d vector3d2 = perpendicularAxis.rotate(physShip.getPoseVel().getRot(), new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"rotate(...)");
        Vector3dc perpAfterRot = (Vector3dc)vector3d2;
        if (otherPhysShip != null) {
            Vector3d vector3d3 = otherPhysShip.getPoseVel().getRot().transformInverse(perpAfterRot, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d3, (String)"transformInverse(...)");
            perpAfterRot = (Vector3dc)vector3d3;
            Vector3d vector3d4 = otherPhysShip.getPoseVel().getRot().transformInverse(bearingAxisAfterRot, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d4, (String)"transformInverse(...)");
            bearingAxisAfterRot = (Vector3dc)vector3d4;
        }
        if (bearingAxisAfterRot.angleCos(data.getBearingAxis()) < 0.9961947 && bearingAxisAfterRot.angleCos(data.getBearingAxis()) > -0.9961947) {
            return (Vector3dc)new Vector3d();
        }
        Vector3d vector3d5 = perpAfterRot.sub((Vector3dc)data.getBearingAxis().mul(data.getBearingAxis().dot(perpAfterRot), new Vector3d()), new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d5, (String)"sub(...)");
        Vector3dc perpAfterRotInPlane = (Vector3dc)vector3d5;
        double angleBTShipInRadians = perpAfterRotInPlane.angle(perpendicularAxis);
        Vector3d vector3d6 = perpAfterRotInPlane.cross(perpendicularAxis, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d6, (String)"cross(...)");
        Vector3dc crossOfYourMother = (Vector3dc)vector3d6;
        double angleWRespectToBearingAxis = crossOfYourMother.lengthSquared() > 1.0E-12 ? angleBTShipInRadians * Math.signum(crossOfYourMother.dot(data.getBearingAxis())) * (double)-1 : 0.0;
        for (angleErr = Math.toRadians(data.getBearingAngle()) - angleWRespectToBearingAxis; angleErr > Math.PI; angleErr -= Math.PI * 2) {
        }
        while (angleErr < -Math.PI) {
            angleErr += Math.PI * 2;
        }
        Vector3d vector3d7 = physShip.getTransform().getWorldToShip().transformDirection((Vector3dc)actualRelativeOmega, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d7, (String)"transformDirection(...)");
        Vector3dc relativeOmegaInPhysShip = (Vector3dc)vector3d7;
        double relativeOmegaInPhysShipParallelBearingAxis = data.getBearingAxis().dot(relativeOmegaInPhysShip);
        double omegaErr = (double)data.getBearingRPM() * 0.10471975511965977 - relativeOmegaInPhysShipParallelBearingAxis;
        double torque = angleErr * torqueMassMultiplier * 50.0 + omegaErr * torqueMassMultiplier * 50.0;
        Vector3d vector3d8 = bearingAxisInGlobal.mul(torque, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d8, (String)"mul(...)");
        return (Vector3dc)vector3d8;
    }

    public final int addPhysBearing(@NotNull PhysBearingCreateData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int n = this.nextBearingID;
        this.nextBearingID = n + 1;
        int id = n;
        this.createdBearings.add((Pair<Integer, PhysBearingCreateData>)new Pair((Object)id, (Object)data));
        return id;
    }

    public final void removePhysBearing(int id) {
        this.removedBearings.add(id);
    }

    public final void updatePhysBearing(int id, @NotNull PhysBearingUpdateData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Integer n = id;
        ((Map)this.bearingUpdateData).put(n, data);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        Queue right$iv;
        Queue left$iv;
        if (this == other) {
            return true;
        }
        if (!(other instanceof BearingController)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.bearingData, ((BearingController)other).bearingData)) return false;
        if (!Intrinsics.areEqual(this.bearingUpdateData, ((BearingController)other).bearingUpdateData)) return false;
        Companion companion = Companion;
        Queue queue = this.createdBearings;
        Queue queue2 = ((BearingController)other).createdBearings;
        boolean $i$f$areQueuesEqual = false;
        Object $this$toTypedArray$iv$iv = (Object[])left$iv;
        boolean $i$f$toTypedArray = false;
        Object[] thisCollection$iv$iv = $this$toTypedArray$iv$iv;
        $this$toTypedArray$iv$iv = thisCollection$iv$iv.toArray(new Pair[0]);
        Object[] $this$toTypedArray$iv$iv2 = (Object[])right$iv;
        boolean $i$f$toTypedArray2 = false;
        Object thisCollection$iv$iv2 = $this$toTypedArray$iv$iv2;
        $this$toTypedArray$iv$iv2 = thisCollection$iv$iv2.toArray(new Pair[0]);
        if (!Arrays.equals((Object[])$this$toTypedArray$iv$iv, $this$toTypedArray$iv$iv2)) return false;
        Companion this_$iv = Companion;
        left$iv = this.removedBearings;
        right$iv = ((BearingController)other).removedBearings;
        $i$f$areQueuesEqual = false;
        $this$toTypedArray$iv$iv = left$iv;
        $i$f$toTypedArray = false;
        Object thisCollection$iv$iv22 = $this$toTypedArray$iv$iv;
        Object[] objectArray = thisCollection$iv$iv22.toArray(new Integer[0]);
        Collection $this$toTypedArray$iv$iv22 = right$iv;
        $i$f$toTypedArray = false;
        thisCollection$iv$iv2 = $this$toTypedArray$iv$iv22;
        Object[] objectArray2 = thisCollection$iv$iv2.toArray(new Integer[0]);
        if (!Arrays.equals(objectArray, objectArray2)) return false;
        if (this.nextBearingID != ((BearingController)other).nextBearingID) return false;
        return true;
    }

    public final boolean canDisassemble() {
        return false;
    }

    public final void setAligning(boolean yn, int id) {
        PhysBearingData physBearingData = this.bearingData.get(id);
        Intrinsics.checkNotNull((Object)physBearingData);
        physBearingData.setAligning(yn);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ4\u0010\u0007\u001a\u00020\u0006\"\u0006\b\u0000\u0010\u0002\u0018\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0086\b\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/valkyrienskies/clockwork/content/forces/contraption/BearingController$Companion;", "", "T", "Ljava/util/Queue;", "left", "right", "", "areQueuesEqual", "(Ljava/util/Queue;Ljava/util/Queue;)Z", "Lorg/valkyrienskies/core/api/ships/ServerShip;", "ship", "Lorg/valkyrienskies/clockwork/content/forces/contraption/BearingController;", "getOrCreate", "(Lorg/valkyrienskies/core/api/ships/ServerShip;)Lorg/valkyrienskies/clockwork/content/forces/contraption/BearingController;", "<init>", "()V", "clockwork"})
    @SourceDebugExtension(value={"SMAP\nBearingController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BearingController.kt\norg/valkyrienskies/clockwork/content/forces/contraption/BearingController$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,344:1\n37#2,2:345\n*S KotlinDebug\n*F\n+ 1 BearingController.kt\norg/valkyrienskies/clockwork/content/forces/contraption/BearingController$Companion\n*L\n340#1:345,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final BearingController getOrCreate(@NotNull ServerShip ship) {
            Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
            if (ship.getAttachment(BearingController.class) == null) {
                ship.saveAttachment(BearingController.class, (Object)new BearingController());
            }
            return (BearingController)ship.getAttachment(BearingController.class);
        }

        public final /* synthetic */ <T> boolean areQueuesEqual(Queue<T> left, Queue<T> right) {
            Intrinsics.checkNotNullParameter(left, (String)"left");
            Intrinsics.checkNotNullParameter(right, (String)"right");
            boolean $i$f$areQueuesEqual = false;
            Collection $this$toTypedArray$iv = left;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Intrinsics.reifiedOperationMarker((int)0, (String)"T?");
            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
            Collection $this$toTypedArray$iv2 = right;
            boolean $i$f$toTypedArray2 = false;
            Collection thisCollection$iv2 = $this$toTypedArray$iv2;
            Intrinsics.reifiedOperationMarker((int)0, (String)"T?");
            Object[] objectArray2 = thisCollection$iv2.toArray(new Object[0]);
            return Arrays.equals(objectArray, objectArray2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

