/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.kinetics.resistor;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.RotationPropagator;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.transmission.SplitShaftBlockEntity;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1937;
import net.minecraft.class_1953;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.util.ClockworkConstants;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\f\u0010*\u001a\b\u0012\u0002\b\u0003\u0018\u00010)\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010&\u001a\u00020+\u00a2\u0006\u0004\b,\u0010-J%\u0010\b\u001a\u00020\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0006H\u0014\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u001e\u0010\fJ\u001f\u0010\u001f\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001f\u0010\u001dR\"\u0010 \u001a\u00020\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\"\u0010&\u001a\u00020\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010!\u001a\u0004\b'\u0010#\"\u0004\b(\u0010%\u00a8\u0006."}, d2={"Lorg/valkyrienskies/clockwork/content/kinetics/resistor/RedstoneResistorBlockEntity;", "Lcom/simibubi/create/content/kinetics/transmission/SplitShaftBlockEntity;", "Lcom/simibubi/create/content/equipment/goggles/IHaveGoggleInformation;", "", "Lnet/minecraft/class_2561;", "tooltip", "", "isPlayerSneaking", "addToGoggleTooltip", "(Ljava/util/List;Z)Z", "", "detachKinetics", "()V", "Lnet/minecraft/class_1937;", "worldIn", "Lnet/minecraft/class_2338;", "pos", "", "getPower", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;)I", "Lnet/minecraft/class_2350;", "face", "", "getRotationSpeedModifier", "(Lnet/minecraft/class_2350;)F", "Lnet/minecraft/class_2487;", "compound", "clientPacket", "read", "(Lnet/minecraft/class_2487;Z)V", "tick", "write", "lastChange", "I", "getLastChange", "()I", "setLastChange", "(I)V", "state", "getState", "setState", "Lnet/minecraft/class_2591;", "type", "Lnet/minecraft/class_2680;", "<init>", "(Lnet/minecraft/class_2591;Lnet/minecraft/class_2338;Lnet/minecraft/class_2680;)V", "clockwork"})
public class RedstoneResistorBlockEntity
extends SplitShaftBlockEntity
implements IHaveGoggleInformation {
    private int state;
    private int lastChange;

    public RedstoneResistorBlockEntity(@Nullable class_2591<?> type, @NotNull class_2338 pos, @NotNull class_2680 state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
    }

    public final int getState() {
        return this.state;
    }

    public final void setState(int n) {
        this.state = n;
    }

    public final int getLastChange() {
        return this.lastChange;
    }

    public final void setLastChange(int n) {
        this.lastChange = n;
    }

    public void tick() {
        super.tick();
        this.lastChange = this.state;
        class_1937 class_19372 = this.field_11863;
        Intrinsics.checkNotNull((Object)class_19372);
        class_2338 class_23382 = this.field_11867;
        Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"worldPosition");
        this.state = this.getPower(class_19372, class_23382);
        if (this.state != this.lastChange) {
            this.detachKinetics();
        }
    }

    public void detachKinetics() {
        RotationPropagator.handleRemoved((class_1937)this.field_11863, (class_2338)this.field_11867, (KineticBlockEntity)((KineticBlockEntity)this));
        class_1937 class_19372 = this.field_11863;
        Intrinsics.checkNotNull((Object)class_19372);
        class_19372.method_39280(this.field_11867, this.method_11010().method_26204(), 0, class_1953.field_9315);
    }

    public void write(@NotNull class_2487 compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        compound.method_10569(ClockworkConstants.Nbt.INSTANCE.getREDSTONE_LEVEL(), this.state);
        compound.method_10569(ClockworkConstants.Nbt.INSTANCE.getCHANGE_TIMER(), this.lastChange);
        super.write(compound, clientPacket);
    }

    protected void read(@NotNull class_2487 compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        this.state = compound.method_10550(ClockworkConstants.Nbt.INSTANCE.getREDSTONE_LEVEL());
        this.lastChange = compound.method_10550(ClockworkConstants.Nbt.INSTANCE.getCHANGE_TIMER());
        super.read(compound, clientPacket);
    }

    private final int getPower(class_1937 worldIn, class_2338 pos) {
        int power = 0;
        Intrinsics.checkNotNullExpressionValue((Object)Iterate.directions, (String)"directions");
        for (class_2350 direction : Iterate.directions) {
            power = Math.max(worldIn.method_49808(pos.method_10093(direction), direction), power);
        }
        Intrinsics.checkNotNullExpressionValue((Object)Iterate.directions, (String)"directions");
        for (class_2350 direction : Iterate.directions) {
            power = Math.max(worldIn.method_49808(pos.method_10093(direction), class_2350.field_11036), power);
        }
        return power;
    }

    public float getRotationSpeedModifier(@NotNull class_2350 face) {
        Intrinsics.checkNotNullParameter((Object)face, (String)"face");
        if (this.hasSource() && face != this.getSourceFacing()) {
            float i = (float)Math.abs(this.state - 15) / 15.0f;
            return i;
        }
        return 1.0f;
    }

    public boolean addToGoggleTooltip(@NotNull List<class_2561> tooltip, boolean isPlayerSneaking) {
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        Object[] objectArray = new Object[]{this.state};
        class_5250 class_52502 = SplitShaftBlockEntity.componentSpacing.method_27662().method_10852((class_2561)Lang.translateDirect((String)"tooltip.analogStrength", (Object[])objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"append(...)");
        tooltip.add((class_2561)class_52502);
        return true;
    }
}

