/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.fabric;

import io.github.fabricators_of_create.porting_lib.event.client.KeyInputCallback;
import io.github.fabricators_of_create.porting_lib.event.client.MouseInputEvents;
import java.io.IOException;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.CoreShaderRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1041;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.valkyrienskies.clockwork.ClockworkBlocks;
import org.valkyrienskies.clockwork.ClockworkModClient;
import org.valkyrienskies.clockwork.ClockworkPartials;
import org.valkyrienskies.clockwork.ClockworkParticles;
import org.valkyrienskies.clockwork.ClockworkShaders;
import org.valkyrienskies.clockwork.content.contraptions.phys.slicker.GooBlock;
import org.valkyrienskies.clockwork.content.contraptions.phys.slicker.SlickerBlock;
import org.valkyrienskies.clockwork.content.curiosities.tools.gravitron.GravitronHandler;
import org.valkyrienskies.clockwork.content.curiosities.tools.wanderwand.WanderWandClusterRenderer;
import org.valkyrienskies.clockwork.fabric.FabricClockworkClientEvents;
import org.valkyrienskies.clockwork.fabric.FabricClockworkInputEvents;
import org.valkyrienskies.clockwork.fabric.FabricClockworkPartials;

public class ClockworkModFabricClient
implements ClientModInitializer {
    public static final GravitronHandler GRAVITRON_HANDLER = new GravitronHandler();
    public static final WanderWandClusterRenderer WANDER_HANDLER = new WanderWandClusterRenderer();

    public void onInitializeClient() {
        ClockworkModClient.initClient();
        ClockworkPartials.INSTANCE.init();
        FabricClockworkPartials.init();
        ClockworkParticles.initClient();
        ClockworkModFabricClient.registerClientEvents();
        FabricClockworkClientEvents.register();
        CoreShaderRegistrationCallback.EVENT.register(this::registerShaders);
        KeyInputCallback.EVENT.register(FabricClockworkInputEvents::onKeyInput);
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)ClockworkBlocks.GOO_BLOCK.get(), class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putItem(((GooBlock)((Object)ClockworkBlocks.GOO_BLOCK.get())).method_8389(), class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putItem(((SlickerBlock)((Object)ClockworkBlocks.SLICKER.get())).method_8389(), class_1921.method_23583());
        MouseInputEvents.BEFORE_SCROLL.register(FabricClockworkInputEvents::onMouseScrolled);
        MouseInputEvents.BEFORE_BUTTON.register(FabricClockworkInputEvents::onMouseInput);
    }

    private void registerShaders(CoreShaderRegistrationCallback.RegistrationContext ctx) throws IOException {
        ctx.register(new class_2960("crystal"), class_290.field_1580, shaderInstance -> {
            ClockworkShaders.crystal = shaderInstance;
        });
        ctx.register(new class_2960("heat"), class_290.field_1580, shaderInstance -> {
            ClockworkShaders.heat = shaderInstance;
        });
        ctx.register(new class_2960("haze"), class_290.field_1580, shaderInstance -> {
            ClockworkShaders.haze = shaderInstance;
        });
    }

    public static void registerClientEvents() {
        ClientTickEvents.END_CLIENT_TICK.register(FabricClockworkClientEvents::onTick);
        ClientTickEvents.START_CLIENT_TICK.register(FabricClockworkClientEvents::onTickStart);
        WorldRenderEvents.AFTER_TRANSLUCENT.register(FabricClockworkClientEvents::onRenderWorld);
        HudRenderCallback.EVENT.register((graphics, partialTicks) -> {
            class_1041 window = class_310.method_1551().method_22683();
            GRAVITRON_HANDLER.render(graphics, partialTicks, window.method_4489(), window.method_4506());
        });
    }
}

