/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.fabric.config;

import com.simibubi.create.content.kinetics.BlockStressValues;
import com.simibubi.create.foundation.config.ConfigBase;
import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigRegistry;
import fuzs.forgeconfigapiport.api.config.v2.ModConfigEvents;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.valkyrienskies.clockwork.fabric.config.CWClient;
import org.valkyrienskies.clockwork.fabric.config.CWCommon;
import org.valkyrienskies.clockwork.fabric.config.CWConfigBase;
import org.valkyrienskies.clockwork.fabric.config.CWServer;

public class AllClockworkConfigs {
    private static final Map<ModConfig.Type, ConfigBase> CONFIGS = new EnumMap<ModConfig.Type, ConfigBase>(ModConfig.Type.class);
    public static CWClient CLIENT;
    public static CWCommon COMMON;
    public static CWServer SERVER;

    public static ConfigBase byType(ModConfig.Type type) {
        return CONFIGS.get(type);
    }

    private static <T extends CWConfigBase> T init(Supplier<T> factory, ModConfig.Type side) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> {
            CWConfigBase config = (CWConfigBase)((Object)((Object)factory.get()));
            config.registerAll((ForgeConfigSpec.Builder)builder);
            return config;
        });
        CWConfigBase config = (CWConfigBase)((Object)specPair.getLeft());
        config.specification = (ForgeConfigSpec)specPair.getRight();
        CONFIGS.put(side, config);
        return (T)((Object)config);
    }

    public static void init() {
        CLIENT = AllClockworkConfigs.init(CWClient::new, ModConfig.Type.CLIENT);
        COMMON = AllClockworkConfigs.init(CWCommon::new, ModConfig.Type.COMMON);
        SERVER = AllClockworkConfigs.init(CWServer::new, ModConfig.Type.SERVER);
        for (Map.Entry<ModConfig.Type, ConfigBase> pair : CONFIGS.entrySet()) {
            ForgeConfigRegistry.INSTANCE.register("vs_clockwork", pair.getKey(), (IConfigSpec)pair.getValue().specification);
        }
        BlockStressValues.registerProvider((String)"vs_clockwork", (BlockStressValues.IStressValueProvider)AllClockworkConfigs.SERVER.kinetics.stressValues);
        ModConfigEvents.loading((String)"vs_clockwork").register(AllClockworkConfigs::onLoad);
        ModConfigEvents.reloading((String)"vs_clockwork").register(AllClockworkConfigs::onReload);
    }

    public static void onLoad(ModConfig modConfig) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onLoad();
        }
    }

    public static void onReload(ModConfig modConfig) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onReload();
        }
    }
}

