/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.platform.fabric;

import com.tterrag.registrate.fabric.EnvExecutor;
import io.netty.buffer.PooledByteBufAllocator;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.platform.api.network.C2SCWPacket;
import org.valkyrienskies.clockwork.platform.api.network.CWPacket;
import org.valkyrienskies.clockwork.platform.api.network.ClientNetworkContext;
import org.valkyrienskies.clockwork.platform.api.network.PacketChannel;
import org.valkyrienskies.clockwork.platform.api.network.S2CCWPacket;
import org.valkyrienskies.clockwork.platform.api.network.ServerNetworkContext;

public class PacketChannelImpl
implements PacketChannel {
    private final Map<Class<? extends C2SCWPacket>, Integer> c2sIdMap = new HashMap<Class<? extends C2SCWPacket>, Integer>();
    private final Map<Class<? extends S2CCWPacket>, Integer> s2cIdMap = new HashMap<Class<? extends S2CCWPacket>, Integer>();
    private final Int2ObjectMap<Function<class_2540, ? extends C2SCWPacket>> c2sDecoderMap = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<Function<class_2540, ? extends S2CCWPacket>> s2cDecoderMap = new Int2ObjectOpenHashMap();
    private final PooledByteBufAllocator bufAllocator = new PooledByteBufAllocator(true);
    private int idCounter = 0;

    public PacketChannelImpl() {
        if (!ServerPlayNetworking.registerGlobalReceiver((class_2960)ClockworkMod.INSTANCE.getNETWORK_CHANNEL(), (server, player, handler, buf, responseSender) -> {
            int id = buf.method_10816();
            Function decoder = (Function)this.c2sDecoderMap.get(id);
            if (decoder == null) {
                throw new RuntimeException("Unknown packet id: " + id);
            }
            C2SCWPacket packet = (C2SCWPacket)decoder.apply(buf);
            packet.handle(this.serverContext((Executor)server, player));
        })) {
            throw new RuntimeException("Failed to register server packet handler");
        }
        EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> {
            if (!ClientPlayNetworking.registerGlobalReceiver((class_2960)ClockworkMod.INSTANCE.getNETWORK_CHANNEL(), (client, handler, buf, responseSender) -> {
                int id = buf.method_10816();
                Function decoder = (Function)this.s2cDecoderMap.get(id);
                if (decoder == null) {
                    throw new RuntimeException("Unknown packet id: " + id);
                }
                S2CCWPacket packet = (S2CCWPacket)decoder.apply(buf);
                packet.handle(this.clientContext((Executor)client));
            })) {
                throw new RuntimeException("Failed to register client packet handler");
            }
        });
    }

    @Override
    public <T extends CWPacket> void registerPacket(Class<T> clazz, Function<class_2540, T> decode) {
        if (C2SCWPacket.class.isAssignableFrom(clazz)) {
            this.c2sIdMap.put(clazz, this.idCounter);
            this.c2sDecoderMap.put(this.idCounter, decode);
            ++this.idCounter;
        } else if (S2CCWPacket.class.isAssignableFrom(clazz)) {
            this.s2cIdMap.put(clazz, this.idCounter);
            this.s2cDecoderMap.put(this.idCounter, decode);
            ++this.idCounter;
        } else {
            throw new RuntimeException();
        }
    }

    private ClientNetworkContext clientContext(final Executor executor) {
        return new ClientNetworkContext(){

            @Override
            public void handled() {
            }

            @Override
            public void enqueueWork(Runnable runnable) {
                executor.execute(runnable);
            }

            @Override
            public void setPacketHandled(boolean value) {
            }
        };
    }

    private ServerNetworkContext serverContext(final Executor executor, final class_3222 player) {
        return new ServerNetworkContext(){

            @Override
            public void handled() {
            }

            @Override
            public class_3222 getSender() {
                return player;
            }

            @Override
            public void enqueueWork(Runnable runnable) {
                executor.execute(runnable);
            }

            @Override
            public void setPacketHandled(boolean value) {
            }
        };
    }

    @Override
    public void sendToNear(class_1937 level, class_2338 pos, int range, S2CCWPacket message) {
        PlayerLookup.around((class_3218)((class_3218)level), (class_2382)pos, (double)range).forEach(player -> this.sendTo((class_3222)player, message));
    }

    @Override
    public void sendToServer(C2SCWPacket packet) {
        class_2540 buf = new class_2540(this.bufAllocator.buffer());
        buf.method_10804(this.c2sIdMap.get(packet.getClass()).intValue());
        packet.write(buf);
        ClientPlayNetworking.send((class_2960)ClockworkMod.INSTANCE.getNETWORK_CHANNEL(), (class_2540)buf);
    }

    @Override
    public void sendToClientsTracking(S2CCWPacket packet, class_1297 entity) {
        PlayerLookup.tracking((class_1297)entity).forEach(player -> this.sendTo((class_3222)player, packet));
    }

    @Override
    public void sendToClientsTrackingAndSelf(S2CCWPacket packet, class_3222 player) {
        PlayerLookup.tracking((class_1297)player).forEach(p -> this.sendTo((class_3222)p, packet));
        this.sendTo(player, packet);
    }

    private void sendTo(class_3222 player, S2CCWPacket packet) {
        class_2540 buf = new class_2540(this.bufAllocator.buffer());
        buf.method_10804(this.s2cIdMap.get(packet.getClass()).intValue());
        packet.write(buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)ClockworkMod.INSTANCE.getNETWORK_CHANNEL(), (class_2540)buf);
    }

    @Override
    public void sendTo(@NotNull S2CCWPacket packet, @NotNull class_3222 player) {
        this.sendTo(player, packet);
    }
}

