/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.util;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.joml.AxisAngle4d;
import org.joml.Matrix4d;
import org.joml.Vector3d;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.world.IPlayer;
import org.valkyrienskies.core.impl.networking.simple.SimplePacket;
import org.valkyrienskies.core.impl.networking.simple.SimplePackets;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.networking.PacketRestartChunkUpdates;
import org.valkyrienskies.mod.common.networking.PacketStopChunkUpdates;
import org.valkyrienskies.mod.common.util.MinecraftPlayer;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.util.RelocationUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lorg/valkyrienskies/clockwork/util/ShipDestroyer;", "", "", "number", "multiple", "roundToNearestMultipleOf", "(DD)D", "Lorg/joml/AxisAngle4d;", "direction", "snapRotation", "(Lorg/joml/AxisAngle4d;)Lorg/joml/AxisAngle4d;", "Lnet/minecraft/class_3218;", "level", "Lorg/valkyrienskies/core/api/ships/ServerShip;", "ship", "Lnet/minecraft/class_2350;", "", "unfillShip", "(Lnet/minecraft/class_3218;Lorg/valkyrienskies/core/api/ships/ServerShip;Lnet/minecraft/class_2350;)V", "<init>", "()V", "clockwork"})
@SourceDebugExtension(value={"SMAP\nShipDestroyer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShipDestroyer.kt\norg/valkyrienskies/clockwork/util/ShipDestroyer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n1360#2:142\n1446#2,5:143\n1549#2:148\n1620#2,3:149\n1855#2,2:152\n1855#2,2:154\n*S KotlinDebug\n*F\n+ 1 ShipDestroyer.kt\norg/valkyrienskies/clockwork/util/ShipDestroyer\n*L\n82#1:142\n82#1:143,5\n83#1:148\n83#1:149,3\n87#1:152,2\n136#1:154,2\n*E\n"})
public final class ShipDestroyer {
    @NotNull
    public static final ShipDestroyer INSTANCE = new ShipDestroyer();

    private ShipDestroyer() {
    }

    private final double roundToNearestMultipleOf(double number, double multiple) {
        return multiple * Math.rint(number / multiple);
    }

    private final AxisAngle4d snapRotation(AxisAngle4d direction) {
        AxisAngle4d axisAngle4d;
        double x = Math.abs(direction.x);
        double y = Math.abs(direction.y);
        double z = Math.abs(direction.z);
        double angle = this.roundToNearestMultipleOf(direction.angle, 1.5707963267948966);
        if (x > y && x > z) {
            AxisAngle4d axisAngle4d2 = direction.set(angle, Math.signum(direction.x), 0.0, 0.0);
            Intrinsics.checkNotNull((Object)axisAngle4d2);
            axisAngle4d = axisAngle4d2;
        } else if (y > x && y > z) {
            AxisAngle4d axisAngle4d3 = direction.set(angle, 0.0, Math.signum(direction.y), 0.0);
            Intrinsics.checkNotNull((Object)axisAngle4d3);
            axisAngle4d = axisAngle4d3;
        } else {
            AxisAngle4d axisAngle4d4 = direction.set(angle, 0.0, 0.0, Math.signum(direction.z));
            Intrinsics.checkNotNull((Object)axisAngle4d4);
            axisAngle4d = axisAngle4d4;
        }
        return axisAngle4d;
    }

    /*
     * WARNING - void declaration
     */
    public final void unfillShip(@NotNull class_3218 level, @NotNull ServerShip ship, @NotNull class_2350 direction) {
        Iterator $this$mapTo$iv$iv;
        Object element$iv$iv2;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        ship.setStatic(true);
        ShipTransform $this$unfillShip_u24lambda_u240 = ship.getTransform();
        boolean bl = false;
        Matrix4d shipToWorld = new Matrix4d().translate($this$unfillShip_u24lambda_u240.getPositionInWorld()).rotate(INSTANCE.snapRotation(new AxisAngle4d($this$unfillShip_u24lambda_u240.getShipToWorldRotation()))).scale($this$unfillShip_u24lambda_u240.getShipToWorldScaling()).translate(-$this$unfillShip_u24lambda_u240.getPositionInShip().x(), -$this$unfillShip_u24lambda_u240.getPositionInShip().y(), -$this$unfillShip_u24lambda_u240.getPositionInShip().z());
        Vector3d alloc0 = new Vector3d();
        class_2470 rotation = switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> class_2470.field_11467;
            case 2 -> class_2470.field_11464;
            case 3 -> class_2470.field_11465;
            case 4 -> class_2470.field_11463;
            default -> class_2470.field_11467;
        };
        Map chunksToBeUpdated = new LinkedHashMap();
        ship.getActiveChunksSet().forEach((arg_0, arg_1) -> ShipDestroyer.unfillShip$lambda$1(chunksToBeUpdated, arg_0, arg_1));
        List chunkPairs = CollectionsKt.toList((Iterable)chunksToBeUpdated.values());
        Iterable $this$flatMap$iv = chunkPairs;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
            Pair it = (Pair)element$iv$iv2;
            boolean bl2 = false;
            Iterable list$iv$iv = TuplesKt.toList((Pair)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List chunkPoses = (List)destination$iv$iv;
        Iterable $this$map$iv = chunkPoses;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        element$iv$iv2 = $this$mapTo$iv$iv.iterator();
        while (element$iv$iv2.hasNext()) {
            void it;
            Object item$iv$iv = element$iv$iv2.next();
            class_1923 bl2 = (class_1923)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl3 = false;
            collection.add(VectorConversionsMCKt.toJOML((class_1923)it));
        }
        List chunkPosesJOML = (List)destination$iv$iv2;
        List list = level.method_18456();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_3222 player = (class_3222)element$iv;
            boolean bl4 = false;
            SimplePacket simplePacket = (SimplePacket)new PacketStopChunkUpdates(chunkPosesJOML);
            Intrinsics.checkNotNull((Object)player);
            MinecraftPlayer minecraftPlayer = VSGameUtilsKt.getPlayerWrapper((class_1657)((class_1657)player));
            Intrinsics.checkNotNullExpressionValue((Object)minecraftPlayer, (String)"<get-playerWrapper>(...)");
            SimplePackets.sendToClient((SimplePacket)simplePacket, (IPlayer)((IPlayer)minecraftPlayer));
        }
        HashSet toUpdate = Sets.newHashSet();
        ship.getActiveChunksSet().forEach((arg_0, arg_1) -> ShipDestroyer.unfillShip$lambda$5(level, shipToWorld, alloc0, toUpdate, rotation, arg_0, arg_1));
        for (Triple triple : toUpdate) {
            RelocationUtilKt.updateBlock((class_1937)((class_1937)level), (class_2338)((class_2338)triple.getFirst()), (class_2338)((class_2338)triple.getSecond()), (class_2680)((class_2680)triple.getThird()));
        }
        MinecraftServer minecraftServer = level.method_8503();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        VSGameUtilsKt.executeIf((MinecraftServer)minecraftServer, (Function0)((Function0)new Function0<Boolean>((List<? extends class_1923>)chunkPoses, level){
            final /* synthetic */ List<class_1923> $chunkPoses;
            final /* synthetic */ class_3218 $level;
            {
                this.$chunkPoses = $chunkPoses;
                this.$level = $level;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke() {
                boolean bl;
                block3: {
                    void $this$all$iv;
                    Iterable iterable = this.$chunkPoses;
                    class_3218 class_32182 = this.$level;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $this$all$iv) {
                            class_1923 p0 = (class_1923)element$iv;
                            boolean bl2 = false;
                            if (VSGameUtilsKt.isTickingChunk((class_1937)((class_1937)class_32182), (class_1923)p0)) continue;
                            bl = false;
                            break block3;
                        }
                        bl = true;
                    }
                }
                return bl;
            }
        }), () -> ShipDestroyer.unfillShip$lambda$7(level, chunkPosesJOML));
    }

    private static final void unfillShip$lambda$1(Map $chunksToBeUpdated, int chunkX, int chunkZ) {
        Intrinsics.checkNotNullParameter((Object)$chunksToBeUpdated, (String)"$chunksToBeUpdated");
        $chunksToBeUpdated.put(new class_1923(chunkX, chunkZ), new Pair((Object)new class_1923(chunkX, chunkZ), (Object)new class_1923(chunkX, chunkZ)));
    }

    private static final void unfillShip$lambda$5(class_3218 $level, Matrix4d $shipToWorld, Vector3d $alloc0, HashSet $toUpdate, class_2470 $rotation, int chunkX, int chunkZ) {
        Intrinsics.checkNotNullParameter((Object)$level, (String)"$level");
        Intrinsics.checkNotNullParameter((Object)$alloc0, (String)"$alloc0");
        Intrinsics.checkNotNullParameter((Object)$rotation, (String)"$rotation");
        class_2818 chunk = $level.method_8497(chunkX, chunkZ);
        int n = chunk.method_12006().length;
        for (int sectionIndex = 0; sectionIndex < n; ++sectionIndex) {
            class_2826 section = chunk.method_12006()[sectionIndex];
            if (section == null || section.method_38292()) continue;
            int bottomY = sectionIndex << 4;
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        class_2680 state = section.method_12254(x, y, z);
                        if (state.method_26215()) continue;
                        int realX = (chunkX << 4) + x;
                        int realY = bottomY + y + $level.method_31607();
                        int realZ = (chunkZ << 4) + z;
                        Vector3d inWorldPos = $shipToWorld.transformPosition($alloc0.set((double)realX + 0.5, (double)realY + 0.5, (double)realZ + 0.5)).floor();
                        class_2338 inWorldBlockPos = new class_2338((int)inWorldPos.x, (int)inWorldPos.y, (int)inWorldPos.z);
                        class_2338 inShipPos = new class_2338(realX, realY, realZ);
                        $toUpdate.add(new Triple((Object)inShipPos, (Object)inWorldBlockPos, (Object)state));
                        RelocationUtilKt.relocateBlock((class_1937)((class_1937)$level), (class_2338)inShipPos, (class_2338)inWorldBlockPos, (boolean)false, null, (class_2470)$rotation);
                    }
                }
            }
        }
    }

    private static final void unfillShip$lambda$7(class_3218 $level, List $chunkPosesJOML) {
        Intrinsics.checkNotNullParameter((Object)$level, (String)"$level");
        Intrinsics.checkNotNullParameter((Object)$chunkPosesJOML, (String)"$chunkPosesJOML");
        List list = $level.method_18456();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_3222 player = (class_3222)element$iv;
            boolean bl = false;
            SimplePacket simplePacket = (SimplePacket)new PacketRestartChunkUpdates($chunkPosesJOML);
            Intrinsics.checkNotNull((Object)player);
            MinecraftPlayer minecraftPlayer = VSGameUtilsKt.getPlayerWrapper((class_1657)((class_1657)player));
            Intrinsics.checkNotNullExpressionValue((Object)minecraftPlayer, (String)"<get-playerWrapper>(...)");
            SimplePackets.sendToClient((SimplePacket)simplePacket, (IPlayer)((IPlayer)minecraftPlayer));
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[class_2350.values().length];
            try {
                nArray[class_2350.field_11035.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[class_2350.field_11043.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[class_2350.field_11034.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[class_2350.field_11039.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

