/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.util.fluid;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3611;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.mixin.accessors.FluidAccessor;
import org.valkyrienskies.clockwork.platform.PlatformUtils;
import org.valkyrienskies.clockwork.util.fluid.CWFluidTank;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 X2\u00020\u0001:\u0002XYB9\b\u0004\u0012\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00000\r\u0012\b\u0010S\u001a\u0004\u0018\u00010R\u0012\u0006\u0010L\u001a\u00020C\u0012\u0006\u0010T\u001a\u00020\u0012\u0012\u0006\u0010U\u001a\u00020\u001b\u00a2\u0006\u0004\bV\u0010WJ\r\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0003J!\u0010\t\u001a\u00020\b2\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0018\u00010\u0006R\u00020\u00000\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000b\u0010\u0003J\r\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b\f\u0010\u0003J\u0013\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J)\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00122\u0010\u0010\u0015\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0018\u00010\u0005H$\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\r\u0010\u001f\u001a\u00020\b\u00a2\u0006\u0004\b\u001f\u0010\u0011J\r\u0010 \u001a\u00020\b\u00a2\u0006\u0004\b \u0010\u0011J\u000f\u0010!\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b!\u0010\u0011J\u000f\u0010\"\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\"\u0010\u0011J\u000f\u0010#\u001a\u00020\bH\u0004\u00a2\u0006\u0004\b#\u0010\u0011J\u0015\u0010&\u001a\u00020\u00002\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\b&\u0010'J\u001f\u0010(\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b(\u0010\u001eR\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00000\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R\"\u0010+\u001a\u00020\u001b8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\"\u0010%\u001a\u00020$8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b%\u00101\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\"\u00106\u001a\u00020\u001b8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b6\u0010,\u001a\u0004\b7\u0010.\"\u0004\b8\u00100R\u0011\u00109\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b9\u0010.R\u0011\u0010<\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0017\u0010?\u001a\b\u0018\u00010\u0006R\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R\"\u0010@\u001a\u00020\u001b8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b@\u0010,\u001a\u0004\bA\u0010.\"\u0004\bB\u00100R\"\u0010D\u001a\u00020C8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\bD\u0010E\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IRB\u0010L\u001a\u000e\u0012\n\u0012\b\u0018\u00010\u0006R\u00020\u00000J2\u0012\u0010K\u001a\u000e\u0012\n\u0012\b\u0018\u00010\u0006R\u00020\u00000J8\u0006@DX\u0086\u000e\u00a2\u0006\u0012\n\u0004\bL\u0010M\u001a\u0004\bN\u0010O\"\u0004\bP\u0010Q\u00a8\u0006Z"}, d2={"Lorg/valkyrienskies/clockwork/util/fluid/CWFluidTankBehaviour;", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "allowExtraction", "()Lorg/valkyrienskies/clockwork/util/fluid/CWFluidTankBehaviour;", "allowInsertion", "Ljava/util/function/Consumer;", "Lorg/valkyrienskies/clockwork/util/fluid/CWFluidTankBehaviour$TankSegment;", "action", "", "forEach", "(Ljava/util/function/Consumer;)V", "forbidExtraction", "forbidInsertion", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BehaviourType;", "getType", "()Lcom/simibubi/create/foundation/blockEntity/behaviour/BehaviourType;", "initialize", "()V", "", "capacity", "Lnet/minecraft/class_3611;", "updateCallback", "Lorg/valkyrienskies/clockwork/util/fluid/CWFluidTank;", "makeFluidTank", "(JLjava/util/function/Consumer;)Lorg/valkyrienskies/clockwork/util/fluid/CWFluidTank;", "Lnet/minecraft/class_2487;", "nbt", "", "clientPacket", "read", "(Lnet/minecraft/class_2487;Z)V", "sendDataImmediately", "sendDataLazily", "tick", "unload", "updateFluids", "Ljava/lang/Runnable;", "fluidUpdateCallback", "whenFluidUpdates", "(Ljava/lang/Runnable;)Lorg/valkyrienskies/clockwork/util/fluid/CWFluidTankBehaviour;", "write", "behaviourType", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BehaviourType;", "extractionAllowed", "Z", "getExtractionAllowed", "()Z", "setExtractionAllowed", "(Z)V", "Ljava/lang/Runnable;", "getFluidUpdateCallback", "()Ljava/lang/Runnable;", "setFluidUpdateCallback", "(Ljava/lang/Runnable;)V", "insertionAllowed", "getInsertionAllowed", "setInsertionAllowed", "isEmpty", "getPrimaryHandler", "()Lorg/valkyrienskies/clockwork/util/fluid/CWFluidTank;", "primaryHandler", "getPrimaryTank", "()Lorg/valkyrienskies/clockwork/util/fluid/CWFluidTankBehaviour$TankSegment;", "primaryTank", "queuedSync", "getQueuedSync", "setQueuedSync", "", "syncCooldown", "I", "getSyncCooldown", "()I", "setSyncCooldown", "(I)V", "", "<set-?>", "tanks", "[Lorg/valkyrienskies/clockwork/util/fluid/CWFluidTankBehaviour$TankSegment;", "getTanks", "()[Lorg/valkyrienskies/clockwork/util/fluid/CWFluidTankBehaviour$TankSegment;", "setTanks", "([Lorg/valkyrienskies/clockwork/util/fluid/CWFluidTankBehaviour$TankSegment;)V", "Lcom/simibubi/create/foundation/blockEntity/SmartBlockEntity;", "te", "tankCapacity", "enforceVariety", "<init>", "(Lcom/simibubi/create/foundation/blockEntity/behaviour/BehaviourType;Lcom/simibubi/create/foundation/blockEntity/SmartBlockEntity;IJZ)V", "Companion", "TankSegment", "clockwork"})
public abstract class CWFluidTankBehaviour
extends BlockEntityBehaviour {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BehaviourType<CWFluidTankBehaviour> behaviourType;
    private int syncCooldown;
    private boolean queuedSync;
    @NotNull
    private TankSegment[] tanks;
    private boolean extractionAllowed;
    private boolean insertionAllowed;
    @NotNull
    private Runnable fluidUpdateCallback;
    @NotNull
    private static final BehaviourType<CWFluidTankBehaviour> TYPE = new BehaviourType();
    @NotNull
    private static final BehaviourType<CWFluidTankBehaviour> INPUT = new BehaviourType("Input");
    @NotNull
    private static final BehaviourType<CWFluidTankBehaviour> OUTPUT = new BehaviourType("Output");
    private static final int SYNC_RATE = 8;

    protected CWFluidTankBehaviour(@NotNull BehaviourType<CWFluidTankBehaviour> behaviourType, @Nullable SmartBlockEntity te, int tanks, long tankCapacity, boolean enforceVariety) {
        Intrinsics.checkNotNullParameter(behaviourType, (String)"behaviourType");
        super(te);
        this.behaviourType = behaviourType;
        this.extractionAllowed = true;
        this.insertionAllowed = true;
        this.tanks = new TankSegment[tanks];
        for (int i = 0; i < tanks; ++i) {
            this.tanks[i] = new TankSegment(tankCapacity);
        }
        this.fluidUpdateCallback = CWFluidTankBehaviour::_init_$lambda$0;
    }

    protected final int getSyncCooldown() {
        return this.syncCooldown;
    }

    protected final void setSyncCooldown(int n) {
        this.syncCooldown = n;
    }

    protected final boolean getQueuedSync() {
        return this.queuedSync;
    }

    protected final void setQueuedSync(boolean bl) {
        this.queuedSync = bl;
    }

    @NotNull
    public final TankSegment[] getTanks() {
        return this.tanks;
    }

    protected final void setTanks(@NotNull TankSegment[] tankSegmentArray) {
        Intrinsics.checkNotNullParameter((Object)tankSegmentArray, (String)"<set-?>");
        this.tanks = tankSegmentArray;
    }

    protected final boolean getExtractionAllowed() {
        return this.extractionAllowed;
    }

    protected final void setExtractionAllowed(boolean bl) {
        this.extractionAllowed = bl;
    }

    protected final boolean getInsertionAllowed() {
        return this.insertionAllowed;
    }

    protected final void setInsertionAllowed(boolean bl) {
        this.insertionAllowed = bl;
    }

    @NotNull
    protected final Runnable getFluidUpdateCallback() {
        return this.fluidUpdateCallback;
    }

    protected final void setFluidUpdateCallback(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"<set-?>");
        this.fluidUpdateCallback = runnable;
    }

    @NotNull
    protected abstract CWFluidTank makeFluidTank(long var1, @Nullable Consumer<class_3611> var3);

    @NotNull
    public final CWFluidTankBehaviour whenFluidUpdates(@NotNull Runnable fluidUpdateCallback) {
        Intrinsics.checkNotNullParameter((Object)fluidUpdateCallback, (String)"fluidUpdateCallback");
        this.fluidUpdateCallback = fluidUpdateCallback;
        return this;
    }

    @NotNull
    public final CWFluidTankBehaviour allowInsertion() {
        this.insertionAllowed = true;
        return this;
    }

    @NotNull
    public final CWFluidTankBehaviour allowExtraction() {
        this.extractionAllowed = true;
        return this;
    }

    @NotNull
    public final CWFluidTankBehaviour forbidInsertion() {
        this.insertionAllowed = false;
        return this;
    }

    @NotNull
    public final CWFluidTankBehaviour forbidExtraction() {
        this.extractionAllowed = false;
        return this;
    }

    public void initialize() {
        super.initialize();
        if (this.getWorld().field_9236) {
            return;
        }
        this.forEach(CWFluidTankBehaviour::initialize$lambda$1);
    }

    public void tick() {
        super.tick();
        if (this.syncCooldown > 0) {
            int n = this.syncCooldown;
            this.syncCooldown = n + -1;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.updateFluids();
            }
        }
        this.forEach(CWFluidTankBehaviour::tick$lambda$2);
    }

    public final void sendDataImmediately() {
        this.syncCooldown = 0;
        this.queuedSync = false;
        this.updateFluids();
    }

    public final void sendDataLazily() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        this.updateFluids();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    protected final void updateFluids() {
        this.fluidUpdateCallback.run();
        this.blockEntity.sendData();
        this.blockEntity.method_5431();
    }

    public void unload() {
        super.unload();
    }

    @NotNull
    public final CWFluidTank getPrimaryHandler() {
        TankSegment tankSegment = this.getPrimaryTank();
        Intrinsics.checkNotNull((Object)tankSegment);
        return tankSegment.getTank();
    }

    @Nullable
    public final TankSegment getPrimaryTank() {
        return this.tanks[0];
    }

    public final boolean isEmpty() {
        TankSegment[] tankSegmentArray = this.tanks;
        int n = tankSegmentArray.length;
        for (int i = 0; i < n; ++i) {
            TankSegment tankSegment;
            TankSegment tankSegment2 = tankSegment = tankSegmentArray[i];
            Intrinsics.checkNotNull((Object)tankSegment2);
            if (tankSegment2.getTank().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public final void forEach(@NotNull Consumer<TankSegment> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        for (TankSegment tankSegment : this.tanks) {
            action.accept(tankSegment);
        }
    }

    public void write(@NotNull class_2487 nbt, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.write(nbt, clientPacket);
        class_2499 tanksNBT = new class_2499();
        this.forEach(arg_0 -> CWFluidTankBehaviour.write$lambda$3(tanksNBT, arg_0));
        nbt.method_10566(this.getType().getName() + "Tanks", (class_2520)tanksNBT);
    }

    public void read(@NotNull class_2487 nbt, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.read(nbt, clientPacket);
        MutableInt index = new MutableInt(0);
        NBTHelper.iterateCompoundList((class_2499)nbt.method_10554(this.getType().getName() + "Tanks", 10), arg_0 -> CWFluidTankBehaviour.read$lambda$4(index, this, clientPacket, arg_0));
    }

    @NotNull
    public BehaviourType<?> getType() {
        return this.behaviourType;
    }

    private static final void _init_$lambda$0() {
    }

    private static final void initialize$lambda$1(TankSegment ts) {
        TankSegment tankSegment = ts;
        Intrinsics.checkNotNull((Object)tankSegment);
        tankSegment.getFluidLevel().forceNextSync();
        ts.onFluidChanged();
    }

    private static final void tick$lambda$2(TankSegment te) {
        TankSegment tankSegment = te;
        Intrinsics.checkNotNull((Object)tankSegment);
        LerpedFloat fluidLevel = tankSegment.getFluidLevel();
        if (fluidLevel != null) {
            fluidLevel.tickChaser();
        }
    }

    private static final void write$lambda$3(class_2499 $tanksNBT, TankSegment ts) {
        Intrinsics.checkNotNullParameter((Object)$tanksNBT, (String)"$tanksNBT");
        TankSegment tankSegment = ts;
        Intrinsics.checkNotNull((Object)tankSegment);
        $tanksNBT.add((Object)tankSegment.writeNBT());
    }

    private static final void read$lambda$4(MutableInt $index, CWFluidTankBehaviour this$0, boolean $clientPacket, class_2487 c) {
        Intrinsics.checkNotNullParameter((Object)$index, (String)"$index");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if ($index.intValue() >= this$0.tanks.length) {
            return;
        }
        TankSegment tankSegment = this$0.tanks[$index.intValue()];
        Intrinsics.checkNotNull((Object)tankSegment);
        tankSegment.readNBT(c, $clientPacket);
        $index.increment();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0007\u001a\u00020\u00062\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\t8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000b\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\t8\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000b\u001a\u0004\b\u0014\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/valkyrienskies/clockwork/util/fluid/CWFluidTankBehaviour$Companion;", "", "Lcom/simibubi/create/foundation/blockEntity/SmartBlockEntity;", "te", "", "capacity", "Lorg/valkyrienskies/clockwork/util/fluid/CWFluidTankBehaviour;", "single", "(Lcom/simibubi/create/foundation/blockEntity/SmartBlockEntity;J)Lorg/valkyrienskies/clockwork/util/fluid/CWFluidTankBehaviour;", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BehaviourType;", "INPUT", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BehaviourType;", "getINPUT", "()Lcom/simibubi/create/foundation/blockEntity/behaviour/BehaviourType;", "OUTPUT", "getOUTPUT", "", "SYNC_RATE", "I", "TYPE", "getTYPE", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BehaviourType<CWFluidTankBehaviour> getTYPE() {
            return TYPE;
        }

        @NotNull
        public final BehaviourType<CWFluidTankBehaviour> getINPUT() {
            return INPUT;
        }

        @NotNull
        public final BehaviourType<CWFluidTankBehaviour> getOUTPUT() {
            return OUTPUT;
        }

        @NotNull
        public final CWFluidTankBehaviour single(@Nullable SmartBlockEntity te, long capacity) {
            BehaviourType<CWFluidTankBehaviour> behaviourType = this.getTYPE();
            SmartBlockEntity smartBlockEntity = te;
            Intrinsics.checkNotNull((Object)smartBlockEntity);
            return PlatformUtils.cwFluidTank(behaviourType, smartBlockEntity, 1, capacity, false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010*\u001a\u00020)\u00a2\u0006\u0004\b+\u0010,J\u0015\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\f\u00a2\u0006\u0004\b\u0011\u0010\u0012R*\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00138\u0006@DX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR.\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u001b8\u0006@DX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R*\u0010#\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\"8\u0006@DX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u0006-"}, d2={"Lorg/valkyrienskies/clockwork/util/fluid/CWFluidTankBehaviour$TankSegment;", "", "", "partialTicks", "getTotalUnits", "(F)F", "", "isEmpty", "(F)Z", "", "onFluidChanged", "()V", "Lnet/minecraft/class_2487;", "compound", "clientPacket", "readNBT", "(Lnet/minecraft/class_2487;Z)V", "writeNBT", "()Lnet/minecraft/class_2487;", "Lcom/simibubi/create/foundation/utility/animation/LerpedFloat;", "<set-?>", "fluidLevel", "Lcom/simibubi/create/foundation/utility/animation/LerpedFloat;", "getFluidLevel", "()Lcom/simibubi/create/foundation/utility/animation/LerpedFloat;", "setFluidLevel", "(Lcom/simibubi/create/foundation/utility/animation/LerpedFloat;)V", "Lnet/minecraft/class_3611;", "renderedFluid", "Lnet/minecraft/class_3611;", "getRenderedFluid", "()Lnet/minecraft/class_3611;", "setRenderedFluid", "(Lnet/minecraft/class_3611;)V", "Lorg/valkyrienskies/clockwork/util/fluid/CWFluidTank;", "tank", "Lorg/valkyrienskies/clockwork/util/fluid/CWFluidTank;", "getTank", "()Lorg/valkyrienskies/clockwork/util/fluid/CWFluidTank;", "setTank", "(Lorg/valkyrienskies/clockwork/util/fluid/CWFluidTank;)V", "", "capacity", "<init>", "(Lorg/valkyrienskies/clockwork/util/fluid/CWFluidTankBehaviour;J)V", "clockwork"})
    public final class TankSegment {
        @NotNull
        private CWFluidTank tank;
        @NotNull
        private LerpedFloat fluidLevel;
        @Nullable
        private class_3611 renderedFluid;

        public TankSegment(long capacity) {
            this.tank = CWFluidTankBehaviour.this.makeFluidTank(capacity, arg_0 -> TankSegment._init_$lambda$0(this, arg_0));
            LerpedFloat lerpedFloat = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.25, LerpedFloat.Chaser.EXP);
            Intrinsics.checkNotNullExpressionValue((Object)lerpedFloat, (String)"chase(...)");
            this.fluidLevel = lerpedFloat;
        }

        @NotNull
        public final CWFluidTank getTank() {
            return this.tank;
        }

        protected final void setTank(@NotNull CWFluidTank cWFluidTank) {
            Intrinsics.checkNotNullParameter((Object)cWFluidTank, (String)"<set-?>");
            this.tank = cWFluidTank;
        }

        @NotNull
        public final LerpedFloat getFluidLevel() {
            return this.fluidLevel;
        }

        protected final void setFluidLevel(@NotNull LerpedFloat lerpedFloat) {
            Intrinsics.checkNotNullParameter((Object)lerpedFloat, (String)"<set-?>");
            this.fluidLevel = lerpedFloat;
        }

        @Nullable
        public final class_3611 getRenderedFluid() {
            return this.renderedFluid;
        }

        protected final void setRenderedFluid(@Nullable class_3611 class_36112) {
            this.renderedFluid = class_36112;
        }

        public final void onFluidChanged() {
            if (!CWFluidTankBehaviour.this.blockEntity.method_11002()) {
                return;
            }
            this.fluidLevel.chase((double)((float)this.tank.getCurrentAmount() / (float)this.tank.getTotalCapacity()), 0.25, LerpedFloat.Chaser.EXP);
            if (!CWFluidTankBehaviour.this.getWorld().field_9236) {
                CWFluidTankBehaviour.this.sendDataLazily();
            }
            if (CWFluidTankBehaviour.this.blockEntity.isVirtual() && !this.tank.isEmpty()) {
                this.renderedFluid = this.tank.getFluidType();
            }
        }

        public final float getTotalUnits(float partialTicks) {
            return this.fluidLevel.getValue(partialTicks) * (float)this.tank.getTotalCapacity();
        }

        @NotNull
        public final class_2487 writeNBT() {
            class_2487 compound = new class_2487();
            compound.method_10566("TankContent", (class_2520)this.tank.store(new class_2487()));
            compound.method_10566("Level", (class_2520)this.fluidLevel.writeNBT());
            return compound;
        }

        public final void readNBT(@NotNull class_2487 compound, boolean clientPacket) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            this.tank.read(compound.method_10562("TankContent"));
            this.fluidLevel.readNBT(compound.method_10562("Level"), clientPacket);
            if (!this.tank.isEmpty()) {
                this.renderedFluid = this.tank.getFluidType();
            }
        }

        public final boolean isEmpty(float partialTicks) {
            class_3611 renderedFluid = this.renderedFluid;
            Intrinsics.checkNotNull((Object)renderedFluid, (String)"null cannot be cast to non-null type org.valkyrienskies.clockwork.mixin.accessors.FluidAccessor");
            if (((FluidAccessor)renderedFluid).getIfEmpty()) {
                return true;
            }
            float units = this.getTotalUnits(partialTicks);
            return units < 1.0f;
        }

        private static final void _init_$lambda$0(TankSegment this$0, class_3611 f) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.onFluidChanged();
        }
    }
}

