/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.model;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_777;

@Environment(value=EnvType.CLIENT)
public class CompositeBakedModel
extends ForwardingBakedModel {
    private final boolean isVanillaAdapter;
    private final List<class_1087> models;

    public CompositeBakedModel(List<class_1087> models) {
        this.wrapped = models.get(0);
        this.isVanillaAdapter = models.stream().allMatch(FabricBakedModel::isVanillaAdapter);
        this.models = models;
    }

    public static class_1087 of(List<class_1087> models) {
        return models.size() == 1 ? models.get(0) : new CompositeBakedModel(models);
    }

    public boolean isVanillaAdapter() {
        return this.isVanillaAdapter;
    }

    public List<class_777> method_4707(@Nullable class_2680 blockState, @Nullable class_2350 face, class_5819 rand) {
        List[] quads = new List[this.models.size()];
        int i = 0;
        for (class_1087 model : this.models) {
            quads[i++] = model.method_4707(blockState, face, rand);
        }
        return new ConcatListView(quads);
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        for (class_1087 model : this.models) {
            model.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        }
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        for (class_1087 model : this.models) {
            model.emitItemQuads(stack, randomSupplier, context);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static final class ConcatListView
    extends AbstractList<class_777> {
        private final List<class_777>[] quads;

        private ConcatListView(List<class_777>[] quads) {
            this.quads = quads;
        }

        @Override
        public Iterator<class_777> iterator() {
            return this.stream().iterator();
        }

        @Override
        public Stream<class_777> stream() {
            return Arrays.stream(this.quads).flatMap(Collection::stream);
        }

        @Override
        public class_777 get(int index) {
            int i = index;
            for (List<class_777> modelQuads : this.quads) {
                if (i < modelQuads.size()) {
                    return modelQuads.get(i);
                }
                i -= modelQuads.size();
            }
            throw new IndexOutOfBoundsException(i);
        }

        @Override
        public int size() {
            int size = 0;
            for (List<class_777> modelQuads : this.quads) {
                size += modelQuads.size();
            }
            return size;
        }
    }
}

