/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.BaseEncoding;
import dan200.computercraft.core.util.Nullability;
import dan200.computercraft.shared.platform.PlatformHelper;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_2479;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NBTUtil {
    private static final Logger LOG = LoggerFactory.getLogger(NBTUtil.class);
    @VisibleForTesting
    static final BaseEncoding ENCODING = BaseEncoding.base16().lowerCase();
    private static final class_2487 EMPTY_TAG;

    private NBTUtil() {
    }

    public static class_2487 emptyTag() {
        if (EMPTY_TAG.method_10546() != 0) {
            LOG.error("The empty tag has been modified.");
        }
        return EMPTY_TAG;
    }

    public static class_2487 getCompoundOrEmpty(class_2487 tag, String key) {
        class_2520 childTag = tag.method_10580(key);
        return childTag != null && childTag.method_10711() == 10 ? (class_2487)childTag : NBTUtil.emptyTag();
    }

    @Nullable
    public static Object toLua(@Nullable class_2520 tag) {
        if (tag == null) {
            return null;
        }
        return switch (tag.method_10711()) {
            case 1, 2, 3, 4 -> ((class_2514)tag).method_10699();
            case 5, 6 -> ((class_2514)tag).method_10697();
            case 8 -> tag.method_10714();
            case 10 -> {
                class_2487 compound = (class_2487)tag;
                HashMap<String, Object> map = new HashMap<String, Object>(compound.method_10546());
                for (String key : compound.method_10541()) {
                    Object value = NBTUtil.toLua(compound.method_10580(key));
                    if (value == null) continue;
                    map.put(key, value);
                }
                yield map;
            }
            case 9 -> ((class_2499)tag).stream().map(NBTUtil::toLua).toList();
            case 7 -> {
                byte[] array = ((class_2479)tag).method_10521();
                ArrayList<Byte> map = new ArrayList<Byte>(array.length);
                for (byte b : array) {
                    map.add(b);
                }
                yield map;
            }
            case 11 -> Arrays.stream(((class_2495)tag).method_10588()).boxed().toList();
            case 12 -> Arrays.stream(((class_2501)tag).method_10615()).boxed().toList();
            default -> null;
        };
    }

    @Nullable
    public static String getNBTHash(@Nullable class_2487 tag) {
        if (tag == null) {
            return null;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            DataOutputStream output = new DataOutputStream(new DigestOutputStream(digest));
            NBTUtil.writeNamedTag(output, "", (class_2520)tag);
            byte[] hash = digest.digest();
            return ENCODING.encode(hash);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            LOG.error("Cannot hash NBT", (Throwable)e);
            return null;
        }
    }

    private static void writeNamedTag(DataOutput output, String name, class_2520 tag) throws IOException {
        output.writeByte(tag.method_10711());
        if (tag.method_10711() == 0) {
            return;
        }
        output.writeUTF(name);
        NBTUtil.writeTag(output, tag);
    }

    private static void writeTag(DataOutput output, class_2520 tag) throws IOException {
        if (tag instanceof class_2487) {
            class_2487 compound = (class_2487)tag;
            Object[] keys = compound.method_10541().toArray(new String[0]);
            Arrays.sort(keys);
            for (Object key : keys) {
                NBTUtil.writeNamedTag(output, (String)key, Nullability.assertNonNull(compound.method_10580((String)key)));
            }
            output.writeByte(0);
        } else if (tag instanceof class_2499) {
            class_2499 list = (class_2499)tag;
            output.writeByte(list.isEmpty() ? 0 : (int)list.method_10534(0).method_10711());
            output.writeInt(list.size());
            for (class_2520 value : list) {
                NBTUtil.writeTag(output, value);
            }
        } else {
            tag.method_10713(output);
        }
    }

    static {
        if (PlatformHelper.get().isDevelopmentEnvironment()) {
            try {
                Constructor ctor = class_2487.class.getDeclaredConstructor(Map.class);
                ctor.setAccessible(true);
                EMPTY_TAG = (class_2487)ctor.newInstance(Map.of());
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        } else {
            EMPTY_TAG = new class_2487();
        }
    }

    @VisibleForTesting
    static final class DigestOutputStream
    extends OutputStream {
        private final MessageDigest digest;

        DigestOutputStream(MessageDigest digest) {
            this.digest = digest;
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.digest.update(b, off, len);
        }

        @Override
        public void write(int b) {
            this.digest.update((byte)b);
        }
    }
}

