/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.ipnext.inventory.sandbox;

import java.util.List;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.anti_ad.mc.common.annotation.MayThrow;
import org.anti_ad.mc.ipnext.Log;
import org.anti_ad.mc.ipnext.Log$TimedMessage;
import org.anti_ad.mc.ipnext.inventory.data.ExtensionsKt;
import org.anti_ad.mc.ipnext.inventory.data.ItemTracker;
import org.anti_ad.mc.ipnext.inventory.data.MutableItemTracker;
import org.anti_ad.mc.ipnext.inventory.sandbox.ContainerSandbox;
import org.anti_ad.mc.ipnext.inventory.sandbox.ContainerSandboxKt;
import org.anti_ad.mc.ipnext.inventory.sandbox.diffcalculator.DiffCalculator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nItemPlanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemPlanner.kt\norg/anti_ad/mc/ipnext/inventory/sandbox/ItemPlanner\n+ 2 Log.kt\norg/anti_ad/mc/ipnext/Log\n*L\n1#1,79:1\n41#2,25:80\n*S KotlinDebug\n*F\n+ 1 ItemPlanner.kt\norg/anti_ad/mc/ipnext/inventory/sandbox/ItemPlanner\n*L\n62#1:80,25\n*E\n"})
public final class ItemPlanner {
    @NotNull
    private final ContainerSandbox innerSandbox;
    @Nullable
    private ItemTracker trackingItems;

    public ItemPlanner(@NotNull MutableItemTracker mutableItemTracker) {
        Intrinsics.checkNotNullParameter((Object)mutableItemTracker, (String)"");
        this.innerSandbox = new ContainerSandbox(mutableItemTracker, null, 2, null);
    }

    @MayThrow
    private final void innerSync() {
        ItemTracker itemTracker = this.trackingItems;
        if (itemTracker != null) {
            ItemTracker itemTracker2 = itemTracker;
            DiffCalculator.INSTANCE.apply(this.innerSandbox, itemTracker2);
            if (!Intrinsics.areEqual((Object)this.innerSandbox.getItems(), (Object)itemTracker2)) {
                throw new IllegalStateException("ContainerSandbox actual result not same as goal".toString());
            }
            this.trackingItems = null;
            return;
        }
    }

    private final ItemTracker getItemTracker() {
        ItemTracker itemTracker = this.trackingItems;
        if (itemTracker == null) {
            itemTracker = this.innerSandbox.getItems();
        }
        return itemTracker;
    }

    @MayThrow
    public final void sandbox(@NotNull Function1 function1) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"");
        this.innerSync();
        function1.invoke((Object)this.innerSandbox);
    }

    @MayThrow
    public final void tracker(@NotNull Function1 object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        int n2 = this.innerSandbox.getClickCount();
        ItemTracker itemTracker = this.getItemTracker();
        Object object2 = Log.INSTANCE;
        Object object3 = "Start sort planing...";
        if (((Boolean)object2.getShouldTrace().invoke()).booleanValue()) {
            long l2 = System.nanoTime();
            Integer n3 = (Integer)((Log)((Object)object2)).getIndent().get();
            CharSequence charSequence = "  ";
            Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"");
            StringsKt.repeat((CharSequence)charSequence, (int)n3);
            object3 = new Log$TimedMessage((String)object3, l2, n3, 0L, null, 16, null);
            Log$TimedMessage log$TimedMessage = (Log$TimedMessage)((Log)((Object)object2)).getParentMessage().get();
            Object object4 = log$TimedMessage;
            if (log$TimedMessage != null && (object4 = ((Log$TimedMessage)object4).getChildren()) != null) {
                object4.add(object3);
            }
            ((Log)((Object)object2)).getParentMessage().set(object3);
            ((Log)((Object)object2)).getIndent().set(n3 + 1);
            try {
                MutableItemTracker mutableItemTracker = this.getItemTracker().copyAsMutable();
                object.invoke((Object)mutableItemTracker);
                object = mutableItemTracker;
            }
            finally {
                ((Log)((Object)object2)).getIndent().set(n3);
                ((Log$TimedMessage)object3).setEnd(System.nanoTime());
                ((Log)((Object)object2)).getParentMessage().set(log$TimedMessage);
                if (log$TimedMessage == null) {
                    ((Log)((Object)object2)).traceTimedTree((Log$TimedMessage)object3);
                }
            }
            v2 = object;
        } else {
            object2 = this.getItemTracker().copyAsMutable();
            object.invoke(object2);
            v2 = object = object2;
        }
        if (n2 != this.innerSandbox.getClickCount()) {
            throw new IllegalStateException(("ContainerSandbox out of sync expected " + n2 + " current " + this.innerSandbox.getClickCount()).toString());
        }
        if (!Intrinsics.areEqual((Object)ExtensionsKt.collect(itemTracker), (Object)ExtensionsKt.collect((ItemTracker)object))) {
            throw new IllegalStateException("Unequal before and after item counts".toString());
        }
        this.trackingItems = (ItemTracker)object;
    }

    @MayThrow
    @NotNull
    public final List getClicks() {
        this.innerSync();
        return ContainerSandboxKt.toList(this.innerSandbox.getClickNode());
    }
}

